<?php
$title= "Product List";
include 'header.php';
?>
<h3>Product List</h3>
<?php echo getMessage();?>
<table border="1" style="border-collapse:collapse;">
    <thead>
        <tr>
            <th>
                P. ID
            </th>
            <th>
                P Code
            </th>
            <th>
               P Name
            </th>
            <th>
                MRP
            </th>
            <th>
                PV
            </th>
            <th>
                P. Cost
            </th>
            <th>
                Qty.
            </th>
            <th>Edit</th>
            <th>
                Delete
            </th>
        </tr>
    </thead>
    <tbody>
        <?php
        $query = "Select * from product order by pname";
        include_once('lib/ps_pagination.php');
	
	/*
	 * Create a PS_Pagination object
	 * 
	 * $conn = MySQL connection object
	 * $sql = SQl Query to paginate
	 * 10 = Number of rows per page
	 * 5 = Number of links
	 * "param1=valu1&param2=value2" = You can append your own parameters to paginations links
	 */
        $pager = new PS_Pagination($link, $query, 20, 5);
	
	/*
	 * Enable debugging if you want o view query errors
	*/
	$pager->setDebug(true);
	
	/*
	 * The paginate() function returns a mysql result set
	 * or false if no rows are returned by the query
	*/
	$rs = $pager->paginate();
	if(!$rs) exit("");
        
        while($row = mysqli_fetch_object($rs)){
            echo "<tr><td>$row->pid</td> <td>$row->pcode</td> <td>$row->pname</td> <td>$row->mrp</td> <td>$row->pv</td> 
                    <td>$row->pcost</td> <td>$row->quantity</td>
                        <td><a href='product_edit.php?pid=".$row->pid."'>Edit</a></td>
                    <td><a href='delete_product.php?pid=".$row->pid."'>Delete</a></td>
                    <tr> ";
        }
        ?>
    </tbody>
</table>
<?php 
//Display the full navigation in one go
echo $pager->renderFullNav();
?>
<br/>
<?php
include('footer.php');
?>