<?php
$title = "Fund Transfer Report";
include 'header.php';
//include_once('lib/ps_pagination.php');
$uid = $_SESSION['userid'];
if ($master_is_transaction_password && !isset($_SESSION['e_wallet'])) {
    redirect('./transaction_password.php?url=fund_transfer.php');
}
//otp_authenticate("fund_transfer.php");
?>

<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Fund Transfer</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Payments</a></li>
                    <li class="breadcrumb-item active">Fund Transfer Report</li>
                </ol>
            </div>
        </div>
    </div>
    <?php
    $total_closed_amount = mysqli_fetch_object(mysqli_query($connection, "SELECT sum(remaining_amount) as total_amount FROM `transaction` WHERE `uid`='" . $uid . "'  AND remaining_amount > '0' AND txn_mode='0'  AND status = 1 AND txn_type != 201 "))->total_amount;
    $total_unclosed_amount = mysqli_fetch_object(mysqli_query($connection, "SELECT sum(remaining_amount) as total_amount FROM `transaction` WHERE `uid`='" . $uid . "'   AND remaining_amount > '0' AND txn_mode='0'  AND txn_type = 10    "))->total_amount;
    $total_pool_amount = mysqli_fetch_object(mysqli_query($connection, "SELECT sum(remaining_amount) as total_amount FROM `transaction` WHERE `uid`='" . $uid . "'   AND remaining_amount > '0' AND txn_mode='0'  AND txn_type = 201    "))->total_amount;
    
    ?>
    <h4>Total Fund wallet <?php echo empty($total_unclosed_amount) ? 0.00 : $total_unclosed_amount ?> </h4>
    <!--<h4>Total Payout wallet <?php echo empty($total_closed_amount) ? 0.00 : $total_closed_amount ?> </h4>-->
    <h4>Total Pool wallet <?php echo empty($total_pool_amount) ? 0.00 : $total_pool_amount ?> </h4>
<?php echo getMessage(); ?>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <form name="form" id="form" action="fund_transfer_model.php" method="post">
                        <div class="form-group row" >
                            <label class="col-sm-2 col-form-label" id="fund_transfer_type">Fund Use Type <span>*</span></label>
                            <div class="col-sm-6">

                                <label class="radio-inline">
                                    <input type="radio" name="fund_transfer_type" value="fund_transfer" checked onchange="fund_transfer_or_topup(this.value)"> Fund Transfer 
                                </label>
                                <?php if(!$master_is_pin_system && $master_is_fund_transfer_topup) :?>
                                <label class="radio-inline">
                                    <input type="radio" name="fund_transfer_type" value="first_topup" onchange="fund_transfer_or_topup(this.value)">First Topup Id
                                </label>
                                
                                 <label class="radio-inline">
                                    <input type="radio" name="fund_transfer_type" value="upgrade_topup" onchange="fund_transfer_or_topup(this.value)"> Upgrade Id
                                </label>
                                
                                 <label class="radio-inline">
                                    <input type="radio" name="fund_transfer_type" value="renew_topup" onchange="fund_transfer_or_topup(this.value)">Global Pool
                                </label>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="form-group row hidden">
                            <label class="col-sm-2 col-form-label" for="wallet_type">Select Wallet Type <span>*</span></label>
                            <div class="col-sm-10">
                                <select class="custom-select" name="wallet_type" id="wallet_type" required="required" onchange="if (this.value == 'primary_wallet') {
                                            $('#recipient_wallet_type_field').css('display', 'block');
                                        } else {
                                            $('#recipient_wallet_type_field').css('display', 'none');
                                        }">
                                    
                                     <option value=""  selected="selected">select Wallet </option>
                                    <option value="primary_wallet" >Payout Wallet </option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="uid">Enter User Id </label>
                            <div class="col-sm-10">

                                <input class="form-control" type="text" name="login_id" id="login_id" onblur="find_name(this.value)" required="required" maxlength="200">
                                <span id="u_name"></span></br>
                                <!--                                Note: You can transfer fund from Main wallet to self fund wallet by entering your user Id.-->
                            </div>
                        </div>
                        <div id="fund_transfer_content">
                            <div class="form-group row" style="display: none;" id="recipient_wallet_type_field">
                                <label class="col-sm-2 col-form-label" for="recipient_wallet_type">Recipient Wallet <span>*</span></label>
                                <div class="col-sm-6">

                                    <select class="custom-select" name="recipient_wallet_type" id="recipient_wallet_type" required="required">
                                        <option value="fund_wallet" selected="selected">Fund Wallet </option>
                                        <!--<option value="primary_wallet" >Main Wallet </option>-->
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="amount">Enter Amount  </label>
                                <div class="col-sm-10">
                                    <input class="form-control" type="number" name="amount" id="amount"  step="any">
                                    Amount must be less than or equal to Wallet amount.
                                </div>
                            </div>  
                        </div>
                        <div id="topup_content" style="display: none;">
                            <div class="form-group row">
                                <label for="pin"  class="col-sm-2 col-form-label" >Select Pin Type <span>*</span></label>
                                <div class="col-sm-6">
                                    <select class="custom-select" name="type" id="type" required="required">
                                        <option>Select Package</option>
                                        
                                    </select>
                                </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <div>
                                <button style="position: relative; left: 180px;" name="submit" type="submit" id="submit" value="Transfer" class="btn btn-primary waves-effect waves-light">
                                    Submit
                                </button>
                            </div>
                        </div>

                    </form>
                </div>

            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->


</div> <!-- container-fluid -->


<script>
var current_plan_type = 0;
var current_board_type = 0;
var pin_package_options = [];
<?php
  $result_pin_package = mysqli_query($connection, "SELECT id, package_name, package_amount, pin_length FROM pin_package WHERE package_amount >'0' ");
    while ($pin_type = mysqli_fetch_object($result_pin_package)) {?>
           pin_package_options[<?= $pin_type->id ?>] = '<?= $pin_type->package_name ?>'  ;                              
<?php }
?>
// console.log(pin_package_options);

    function find_name(user_id) {
//    alert('refer_id'+refer_id);
        var returnValue = false;
        $.ajax({
            url: "../get_user.php",
            data: {'user_id': user_id},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#u_name").html('<b style="color:red">Invalid Name</b>');
                } else {
                    returnValue = true;
                    current_plan_type= data.user.plan_type;
                    current_board_type= data.user.board_type;
                    $("#u_name").html('<b style="color:green">' + data.user.name + ' - Valid Name</b>');
                    $("#submit").removeAttr("disabled");
                    
                    
                    var fieldValue = $("input[name='fund_transfer_type']:checked").val();
                    set_option(fieldValue);
            
                }
            }
        });
        return returnValue;
    }
    function fund_transfer_or_topup(fieldValue) {
        if (fieldValue == 'fund_transfer') {
            $('#fund_transfer_content').css('display', 'block');
            $('#topup_content').css('display', 'none');
            $('#wallet_type').html('<option value="primary_wallet"  selected="selected">Payout Wallet </option>');
            
        } else {
            $('#fund_transfer_content').css('display', 'none');
            $('#topup_content').css('display', 'block');
            $('#wallet_type').html('<option value="fund_wallet"  selected="selected">Fund Wallet </option>');
             set_option(fieldValue);
            
        }
    }
    function set_option(fieldValue){
        if( !$('#login_id').val()){
            return;
            
        }
        let optionHTML = '';
        console.log('current_plan_type ', current_plan_type);
        
            if(fieldValue == 'upgrade_topup'){
                current_plan_type= current_plan_type == 0 ? 2 : current_plan_type;
                var next_plan_type= parseInt(current_plan_type)  +1;
                for (let i = next_plan_type; i < 201; i++) {
                    //  console.log(i+" - "+pin_package_options[i]);
                    if(pin_package_options[i]){
                         optionHTML += '<option value="'+i+'"  >'+pin_package_options[i]+'</option>';
                     }
             }
            } 
            else if(fieldValue == 'renew_topup'){
                // current_plan_type= current_plan_type == 0 ? 2 : current_plan_type;
                var next_plan_type= parseInt(current_board_type)  +201;
                for (let i = next_plan_type; i <= next_plan_type; i++) {
                     //console.log(i+" - "+pin_package_options[i]);
                    if(pin_package_options[i]){
                         optionHTML += '<option value="'+i+'"  >'+pin_package_options[i]+'</option>';
                     }
             }
            } else {
                for (let i = 2; i < 201; i++) {
                     //console.log(i+" - "+pin_package_options[i]);
                     if(pin_package_options[i]){
                         optionHTML += '<option value="'+i+'"  >'+pin_package_options[i]+'</option>';
                     }
                    
                }
            }
            $('#type').html(optionHTML);
    }
</script>
<?php include('footer.php'); ?>
