<?php
include './header.php';
$date = date('Y-m-d');
$datetime = date('Y-m-d H:i:s');
?>
<!--<link href="./admin/styles/jquery-ui.css" rel="stylesheet" />	
<script src="./admin/scripts/jquery-ui.js"></script>-->
<style>
    .form-group.required .control-label:after { 
        color: #d00;
        content: "*";
        position: absolute;
        margin-left: 8px;
        top:7px;
    }
</style>
<section class="page-title-light breadcrumb_section parallax_bg overlay_bg_50" data-parallax-bg-image="assets/images/r3.png">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-sm-6">
                <div class="page-title">
                    <h1>Register</h1>
                </div>
            </div>
            <div class="col-sm-6">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-sm-end">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Register</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</section>
<div class="container">
    <div class="text-center">
        <h2 style="color:CF1313">Register Here</h2>
    </div>
    <?php echo getMessage(); ?>
    <div class="alert alert-dismissible alert-danger" id="validation_message_container" style="display:none;">
            <div id="validation_success_message"></div>
            <ul id="validation_message_list"></ul>
        </div>
    <form class="form-horizontal" action="register_model.php" name="form" method="post"  id="form" onsubmit="return validateForm();">

        <legend> Account information </legend>
        <fieldset>

<?php if ($master_is_paid_register) : ?>
            <?php if($master_is_pin_system) {?>
                <div class="form-group required">
                    <label for="pin_no" class="col-md-4 control-label">PIN</label>
                    <div class="col-md-6  inputGroupContainer">
                        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                            <input  name="pin_no" value="<?php echo !empty($_GET['pin_no']) ? $_GET['pin_no'] : ''; ?>" type="text" pattern="[0-9]{8,30}" required="required" id="pin_no" onblur="check_pin(this.value);" maxlength="30" class="form-control" />
                        </div>
                        <span id="pin_error" class="help-block" ></span>
                    </div>
                </div>
            <?php } else if($master_project_category == "CRYPTO") { 
                include_once './register_crypto_content.php';
                
            } ?>
<?php endif; ?>
            <div class="form-group required">
                <label class="col-md-4 control-label">Sponsor Id</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input name="refer_id" id="refer_id" type="text" value="<?php echo!empty($_GET['loginid']) ? $_GET['loginid'] : ''; ?>" required="required" onBlur="check_sponser(this.value)" maxlength="20" placeholder="Sponsor Id" class="form-control"  type="text" />
                    </div>
                    <span id="sponser" class="help-block" ></span>
                </div>
            </div>
            <?php if ($master_is_placement_id_field) : ?>
            <div class="form-group required">
                <label class="col-md-4 control-label">Placement Id</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input name="placement_id" id="placement_id" type="text" value="<?php echo!empty($_GET['loginid']) ? $_GET['loginid'] : ''; ?>" onBlur="check_placement(this.value)" required="required" maxlength="20" placeholder="Placement Id" class="form-control"  type="text" />
                    </div>
                    <span id="placement_id_error" class="help-block" ></span>
                </div>
            </div>
            <?php endif; ?>

<?php if ($master_tree_type == "BINARY") : ?> 
                <div class="form-group required">
                    <label class="col-md-4 control-label">Position</label>
                    <div class="col-md-6  inputGroupContainer">
                        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                            <select name="position" id="position" required="required" class="form-control" required="required">
                                <option value="" disabled="disabled" selected="selected">-- Select Position --</option>
                                <option value="L" <?php if ((!empty($_SESSION['position']) && $_SESSION['position'] == 'L') || (!empty($_GET['position']) && $_GET['position'] == 'L')) {
        echo "selected='selected'";
    } elseif ((!empty($_SESSION['position']) && $_SESSION['position'] == 'R') || (!empty($_GET['position']) && $_GET['position'] == 'R')) {
        echo "disabled='disabled'";
    } ?> >Left</option>
                                <option value="R" <?php if ((!empty($_SESSION['position']) && $_SESSION['position'] == 'R') || (!empty($_GET['position']) && $_GET['position'] == 'R')) {
        echo "selected='selected'";
    } elseif ((!empty($_SESSION['position']) && $_SESSION['position'] == 'L') || (!empty($_GET['position']) && $_GET['position'] == 'L')) {
        echo "disabled='disabled'";
    } ?> >Right</option>

                            </select>  
                        </div>
                        <span id="position" class="help-block" style="color: #a94442" ></span>
                    </div>
                </div>
<?php endif; ?>
            <?php if (!$master_is_user_id_field_auto) : ?>
            <div class="form-group required">
                <label class="col-md-4 control-label">User Id</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-envelope"></i></span>
                        <input name="login_id" id="login_id" type="text" pattern="\w{6,20}" required="required" onBlur="check_login_id(this.value)" maxlength="20" placeholder="Enter minimum 6 character" class="form-control"/>
                    </div>
                    <span id="login_error" class="help-block" ></span>
                </div>
            </div>
            <?php endif; ?>
            <div class="form-group required">
                <label class="col-md-4 control-label">Password</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                        <input name="password" id="password" type="password" required="required" maxlength="20" placeholder="Enter minimum 6 character" class="form-control" />
                    </div>
                </div>
            </div>
            <div class="form-group required">
                <label class="col-md-4 control-label">Confirm Password</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                        <input name="re_password" id="confirm_password" type="password"  required="required" onkeyup='check_confirm_password();' maxlength="20" placeholder="Enter minimum 6 character" class="form-control" />
                    </div>
                    <span id="confirm_password_error" class="help-block" ></span>
                </div>
            </div>
            <?php if ($master_is_custom_register_date) : ?>
            <div class="form-group required">
                <label class="col-md-4 control-label">Register Date</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-envelope"></i></span>
                        <input name="register_datetime" id="register_datetime" type="datetime-local" value="<?=$datetime?>" max="<?=$datetime?>" required="required" class="form-control"/>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if ($master_is_custom_register_date && $master_is_paid_register) : ?>
            <div class="form-group required">
                <label class="col-md-4 control-label">Topup Date</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-envelope"></i></span>
                        <input name="topup_datetime" id="topup_datetime" type="datetime-local" value="<?=$datetime?>" max="<?=$datetime?>" required="required" class="form-control"/>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </fieldset>
        <fieldset>

            <!-- Form Name -->
            <legend> Personal Information </legend>

            <!-- Text input-->

            <div class="form-group required">
                <label class="col-md-4 control-label">Name</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input  name="name" id="name" type="text" required="required" maxlength="100" class="form-control" >
                    </div>
                </div>
            </div>
<!--            <div class="form-group required">
                <label class="col-md-4 control-label">Nominee</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input  name="nominee" id="nominee" type="text" required="required" maxlength="100" class="form-control" >
                    </div>
                </div>
            </div>
            <div class="form-group required">
                <label class="col-md-4 control-label">Nominee Relation</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input  name="nominee_relation" id="nominee_relation" type="text" required="required" maxlength="100" class="form-control" >
                    </div>
                </div>
            </div>-->
            <!--<div class="form-group">-->
            <!--    <label class="col-md-4 control-label">DOB</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>-->
            <!--            <input name="dob" id="dob" type="date"  value="" class="form-control" data-provide="datepicker" >-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
            <!--<div class="form-group required">-->
            <!--    <label class="col-md-4 control-label">Gender</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group">-->
            <!--            <input type="radio" id="sex_m" value="Male" checked="checked" name="sex" >-->
            <!--            Male&nbsp;-->
            <!--            <input type="radio" value="Female" id="sex_f" name="sex" />-->
            <!--            Female-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->

            <!--<div class="form-group">-->
            <!--    <label class="col-md-4 control-label">Address</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-home"></i></span>-->
            <!--            <input name="address" id="address" placeholder="Address" class="form-control" type="text">-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->

            <!--<div class="form-group required">-->
            <!--    <label class="col-md-4 control-label">City</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-home"></i></span>-->
            <!--            <input name="city" id="city" placeholder="city" class="form-control"  type="text" required="true">-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->

            <!--<div class="form-group required">-->
            <!--    <label class="col-md-4 control-label">Country</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-home"></i></span>-->
            <!--            <select name="country" id="country" class="form-control">-->
                            <!--<option selected="selected">--Select country--</option>-->
            <!--                <option value="AF" >Afghanistan</option>-->
            <!--                <option value="AX" >Aland Islands</option>-->
            <!--                <option value="AL" >Albania</option>-->
            <!--                <option value="DZ" >Algeria</option>-->
            <!--                <option value="AS" >American Samoa</option>-->
            <!--                <option value="AD" >Andorra</option>-->
            <!--                <option value="AO" >Angola</option>-->
            <!--                <option value="AI" >Anguilla</option>-->
            <!--                <option value="AQ" >Antarctica</option>-->
            <!--                <option value="AG" >Antigua and Barbuda</option>-->
            <!--                <option value="AR" >Argentina</option>-->
            <!--                <option value="AM" >Armenia</option>-->
            <!--                <option value="AW" >Aruba</option>-->
            <!--                <option value="AU" >Australia</option>-->
            <!--                <option value="AT" >Austria</option>-->
            <!--                <option value="AZ" >Azerbaijan</option>-->
            <!--                <option value="BS" >Bahamas</option>-->
            <!--                <option value="BH" >Bahrain</option>-->
            <!--                <option value="BD" >Bangladesh</option>-->
            <!--                <option value="BB" >Barbados</option>-->
            <!--                <option value="BY" >Belarus</option>-->
            <!--                <option value="BE" >Belgium</option>-->
            <!--                <option value="BZ" >Belize</option>-->
            <!--                <option value="BJ" >Benin</option>-->
            <!--                <option value="BM" >Bermuda</option>-->
            <!--                <option value="BT" >Bhutan</option>-->
            <!--                <option value="BO" >Bolivia</option>-->
            <!--                <option value="BQ" >Bonaire, Sint Eustatius and Saba</option>-->
            <!--                <option value="BA" >Bosnia and Herzegovina</option>-->
            <!--                <option value="BW" >Botswana</option>-->
            <!--                <option value="BV" >Bouvet Island</option>-->
            <!--                <option value="BR" >Brazil</option>-->
            <!--                <option value="IO" >British Indian Ocean Territory</option>-->
            <!--                <option value="BN" >Brunei</option>-->
            <!--                <option value="BG" >Bulgaria</option>-->
            <!--                <option value="BF" >Burkina Faso</option>-->
            <!--                <option value="BI" >Burundi</option>-->
            <!--                <option value="KH" >Cambodia</option>-->
            <!--                <option value="CM" >Cameroon</option>-->
            <!--                <option value="CA" >Canada</option>-->
            <!--                <option value="CV" >Cape Verde</option>-->
            <!--                <option value="KY" >Cayman Islands</option>-->
            <!--                <option value="CF" >Central African Republic</option>-->
            <!--                <option value="TD" >Chad</option>-->
            <!--                <option value="CL" >Chile</option>-->
            <!--                <option value="CN" >China</option>-->
            <!--                <option value="CX" >Christmas Island</option>-->
            <!--                <option value="CC" >Cocos (Keeling) Islands</option>-->
            <!--                <option value="CO" >Colombia</option>-->
            <!--                <option value="KM" >Comoros</option>-->
            <!--                <option value="CG" >Congo</option>-->
            <!--                <option value="CK" >Cook Islands</option>-->
            <!--                <option value="CR" >Costa Rica</option>-->
            <!--                <option value="CI" >Cote d'ivoire (Ivory Coast)</option>-->
            <!--                <option value="HR" >Croatia</option>-->
            <!--                <option value="CU" >Cuba</option>-->
            <!--                <option value="CW" >Curacao</option>-->
            <!--                <option value="CY" >Cyprus</option>-->
            <!--                <option value="CZ" >Czech Republic</option>-->
            <!--                <option value="CD" >Democratic Republic of the Congo</option>-->
            <!--                <option value="DK" >Denmark</option>-->
            <!--                <option value="DJ" >Djibouti</option>-->
            <!--                <option value="DM" >Dominica</option>-->
            <!--                <option value="DO" >Dominican Republic</option>-->
            <!--                <option value="EC" >Ecuador</option>-->
            <!--                <option value="EG" >Egypt</option>-->
            <!--                <option value="SV" >El Salvador</option>-->
            <!--                <option value="GQ" >Equatorial Guinea</option>-->
            <!--                <option value="ER" >Eritrea</option>-->
            <!--                <option value="EE" >Estonia</option>-->
            <!--                <option value="ET" >Ethiopia</option>-->
            <!--                <option value="FK" >Falkland Islands (Malvinas)</option>-->
            <!--                <option value="FO" >Faroe Islands</option>-->
            <!--                <option value="FJ" >Fiji</option>-->
            <!--                <option value="FI" >Finland</option>-->
            <!--                <option value="FR" >France</option>-->
            <!--                <option value="GF" >French Guiana</option>-->
            <!--                <option value="PF" >French Polynesia</option>-->
            <!--                <option value="TF" >French Southern Territories</option>-->
            <!--                <option value="GA" >Gabon</option>-->
            <!--                <option value="GM" >Gambia</option>-->
            <!--                <option value="GE" >Georgia</option>-->
            <!--                <option value="DE" >Germany</option>-->
            <!--                <option value="GH" >Ghana</option>-->
            <!--                <option value="GI" >Gibraltar</option>-->
            <!--                <option value="GR" >Greece</option>-->
            <!--                <option value="GL" >Greenland</option>-->
            <!--                <option value="GD" >Grenada</option>-->
            <!--                <option value="GP" >Guadaloupe</option>-->
            <!--                <option value="GU" >Guam</option>-->
            <!--                <option value="GT" >Guatemala</option>-->
            <!--                <option value="GG" >Guernsey</option>-->
            <!--                <option value="GN" >Guinea</option>-->
            <!--                <option value="GW" >Guinea-Bissau</option>-->
            <!--                <option value="GY" >Guyana</option>-->
            <!--                <option value="HT" >Haiti</option>-->
            <!--                <option value="HM" >Heard Island and McDonald Islands</option>-->
            <!--                <option value="HN" >Honduras</option>-->
            <!--                <option value="HK" >Hong Kong</option>-->
            <!--                <option value="HU" >Hungary</option>-->
            <!--                <option value="IS" >Iceland</option>-->
            <!--                <option value="IN"  selected='selected'>India</option>-->
            <!--                <option value="ID" >Indonesia</option>-->
            <!--                <option value="IR" >Iran</option>-->
            <!--                <option value="IQ" >Iraq</option>-->
            <!--                <option value="IE" >Ireland</option>-->
            <!--                <option value="IM" >Isle of Man</option>-->
            <!--                <option value="IL" >Israel</option>-->
            <!--                <option value="IT" >Italy</option>-->
            <!--                <option value="JM" >Jamaica</option>-->
            <!--                <option value="JP" >Japan</option>-->
            <!--                <option value="JE" >Jersey</option>-->
            <!--                <option value="JO" >Jordan</option>-->
            <!--                <option value="KZ" >Kazakhstan</option>-->
            <!--                <option value="KE" >Kenya</option>-->
            <!--                <option value="KI" >Kiribati</option>-->
            <!--                <option value="XK" >Kosovo</option>-->
            <!--                <option value="KW" >Kuwait</option>-->
            <!--                <option value="KG" >Kyrgyzstan</option>-->
            <!--                <option value="LA" >Laos</option>-->
            <!--                <option value="LV" >Latvia</option>-->
            <!--                <option value="LB" >Lebanon</option>-->
            <!--                <option value="LS" >Lesotho</option>-->
            <!--                <option value="LR" >Liberia</option>-->
            <!--                <option value="LY" >Libya</option>-->
            <!--                <option value="LI" >Liechtenstein</option>-->
            <!--                <option value="LT" >Lithuania</option>-->
            <!--                <option value="LU" >Luxembourg</option>-->
            <!--                <option value="MO" >Macao</option>-->
            <!--                <option value="MK" >Macedonia</option>-->
            <!--                <option value="MG" >Madagascar</option>-->
            <!--                <option value="MW" >Malawi</option>-->
            <!--                <option value="MY" >Malaysia</option>-->
            <!--                <option value="MV" >Maldives</option>-->
            <!--                <option value="ML" >Mali</option>-->
            <!--                <option value="MT" >Malta</option>-->
            <!--                <option value="MH" >Marshall Islands</option>-->
            <!--                <option value="MQ" >Martinique</option>-->
            <!--                <option value="MR" >Mauritania</option>-->
            <!--                <option value="MU" >Mauritius</option>-->
            <!--                <option value="YT" >Mayotte</option>-->
            <!--                <option value="MX" >Mexico</option>-->
            <!--                <option value="FM" >Micronesia</option>-->
            <!--                <option value="MD" >Moldava</option>-->
            <!--                <option value="MC" >Monaco</option>-->
            <!--                <option value="MN" >Mongolia</option>-->
            <!--                <option value="ME" >Montenegro</option>-->
            <!--                <option value="MS" >Montserrat</option>-->
            <!--                <option value="MA" >Morocco</option>-->
            <!--                <option value="MZ" >Mozambique</option>-->
            <!--                <option value="MM" >Myanmar (Burma)</option>-->
            <!--                <option value="NA" >Namibia</option>-->
            <!--                <option value="NR" >Nauru</option>-->
            <!--                <option value="NP" >Nepal</option>-->
            <!--                <option value="NL" >Netherlands</option>-->
            <!--                <option value="NC" >New Caledonia</option>-->
            <!--                <option value="NZ" >New Zealand</option>-->
            <!--                <option value="NI" >Nicaragua</option>-->
            <!--                <option value="NE" >Niger</option>-->
            <!--                <option value="NG" >Nigeria</option>-->
            <!--                <option value="NU" >Niue</option>-->
            <!--                <option value="NF" >Norfolk Island</option>-->
            <!--                <option value="KP" >North Korea</option>-->
            <!--                <option value="MP" >Northern Mariana Islands</option>-->
            <!--                <option value="NO" >Norway</option>-->
            <!--                <option value="OM" >Oman</option>-->
            <!--                <option value="PK" >Pakistan</option>-->
            <!--                <option value="PW" >Palau</option>-->
            <!--                <option value="PS" >Palestine</option>-->
            <!--                <option value="PA" >Panama</option>-->
            <!--                <option value="PG" >Papua New Guinea</option>-->
            <!--                <option value="PY" >Paraguay</option>-->
            <!--                <option value="PE" >Peru</option>-->
            <!--                <option value="PH" >Phillipines</option>-->
            <!--                <option value="PN" >Pitcairn</option>-->
            <!--                <option value="PL" >Poland</option>-->
            <!--                <option value="PT" >Portugal</option>-->
            <!--                <option value="PR" >Puerto Rico</option>-->
            <!--                <option value="QA" >Qatar</option>-->
            <!--                <option value="RE" >Reunion</option>-->
            <!--                <option value="RO" >Romania</option>-->
            <!--                <option value="RU" >Russia</option>-->
            <!--                <option value="RW" >Rwanda</option>-->
            <!--                <option value="BL" >Saint Barthelemy</option>-->
            <!--                <option value="SH" >Saint Helena</option>-->
            <!--                <option value="KN" >Saint Kitts and Nevis</option>-->
            <!--                <option value="LC" >Saint Lucia</option>-->
            <!--                <option value="MF" >Saint Martin</option>-->
            <!--                <option value="PM" >Saint Pierre and Miquelon</option>-->
            <!--                <option value="VC" >Saint Vincent and the Grenadines</option>-->
            <!--                <option value="WS" >Samoa</option>-->
            <!--                <option value="SM" >San Marino</option>-->
            <!--                <option value="ST" >Sao Tome and Principe</option>-->
            <!--                <option value="SA" >Saudi Arabia</option>-->
            <!--                <option value="SN" >Senegal</option>-->
            <!--                <option value="RS" >Serbia</option>-->
            <!--                <option value="SC" >Seychelles</option>-->
            <!--                <option value="SL" >Sierra Leone</option>-->
            <!--                <option value="SG" >Singapore</option>-->
            <!--                <option value="SX" >Sint Maarten</option>-->
            <!--                <option value="SK" >Slovakia</option>-->
            <!--                <option value="SI" >Slovenia</option>-->
            <!--                <option value="SB" >Solomon Islands</option>-->
            <!--                <option value="SO" >Somalia</option>-->
            <!--                <option value="ZA" >South Africa</option>-->
            <!--                <option value="GS" >South Georgia and the South Sandwich Islands</option>-->
            <!--                <option value="KR" >South Korea</option>-->
            <!--                <option value="SS" >South Sudan</option>-->
            <!--                <option value="ES" >Spain</option>-->
            <!--                <option value="LK" >Sri Lanka</option>-->
            <!--                <option value="SD" >Sudan</option>-->
            <!--                <option value="SR" >Suriname</option>-->
            <!--                <option value="SJ" >Svalbard and Jan Mayen</option>-->
            <!--                <option value="SZ" >Swaziland</option>-->
            <!--                <option value="SE" >Sweden</option>-->
            <!--                <option value="CH" >Switzerland</option>-->
            <!--                <option value="SY" >Syria</option>-->
            <!--                <option value="TW" >Taiwan</option>-->
            <!--                <option value="TJ" >Tajikistan</option>-->
            <!--                <option value="TZ" >Tanzania</option>-->
            <!--                <option value="TH" >Thailand</option>-->
            <!--                <option value="TL" >Timor-Leste (East Timor)</option>-->
            <!--                <option value="TG" >Togo</option>-->
            <!--                <option value="TK" >Tokelau</option>-->
            <!--                <option value="TO" >Tonga</option>-->
            <!--                <option value="TT" >Trinidad and Tobago</option>-->
            <!--                <option value="TN" >Tunisia</option>-->
            <!--                <option value="TR" >Turkey</option>-->
            <!--                <option value="TM" >Turkmenistan</option>-->
            <!--                <option value="TC" >Turks and Caicos Islands</option>-->
            <!--                <option value="TV" >Tuvalu</option>-->
            <!--                <option value="UG" >Uganda</option>-->
            <!--                <option value="UA" >Ukraine</option>-->
            <!--                <option value="AE" >United Arab Emirates</option>-->
            <!--                <option value="GB" >United Kingdom</option>-->
            <!--                <option value="US" >United States</option>-->
            <!--                <option value="UM" >United States Minor Outlying Islands</option>-->
            <!--                <option value="UY" >Uruguay</option>-->
            <!--                <option value="UZ" >Uzbekistan</option>-->
            <!--                <option value="VU" >Vanuatu</option>-->
            <!--                <option value="VA" >Vatican City</option>-->
            <!--                <option value="VE" >Venezuela</option>-->
            <!--                <option value="VN" >Vietnam</option>-->
            <!--                <option value="VG" >Virgin Islands, British</option>-->
            <!--                <option value="VI" >Virgin Islands, US</option>-->
            <!--                <option value="WF" >Wallis and Futuna</option>-->
            <!--                <option value="EH" >Western Sahara</option>-->
            <!--                <option value="YE" >Yemen</option>-->
            <!--                <option value="ZM" >Zambia</option>-->
            <!--                <option value="ZW" >Zimbabwe</option>-->
            <!--            </select> -->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->


            <div class="form-group required">
                <label class="col-md-4 control-label">Mobile</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-earphone"></i></span>
                        <input name="mobile" id="mobile" type="text" maxlength="20" pattern="[0-9]{10,10}" onBlur="check_mobile(this.value)" required="required" class="form-control">
                    </div>
                    <span id="mobile_error" class="help-block"  ></span>
                </div>
            </div>



            <div class="form-group required">
                <label class="col-md-4 control-label">Email</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-envelope"></i></span>
                        <input name="email" id="email" type="email" maxlength="50" onBlur="check_email(this.value)" required="required" class="form-control" >
                    </div>
                    <span id="email_error" class="help-block" ></span>
                </div>
            </div>

            <?php if ($master_is_show_pan_field) : ?>
            <div class="form-group required">
                <label class="col-md-4 control-label">Pan No.</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-earphone"></i></span>
                        <input name="pan_no" id="pan_no" type="text" maxlength="20"  required="required" onBlur="check_pan(this.value)" class="form-control" />
                    </div>
                    <span id="pan_no_error" class="help-block" ></span>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if ($master_is_show_aadhar_no_field) : ?>
            <div class="form-group required">
                <label class="col-md-4 control-label">Aadhar No.</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-earphone"></i></span>
                        <input name="aadhar_no" id="aadhar_no" type="text" maxlength="20"  required="required" onBlur="check_aadhar(this.value)" class="form-control" />
                    </div>
                    <span id="aadhar_no_error" class="help-block" ></span>
                </div>
            </div>
            <?php endif; ?>

        </fieldset>
        <?php if ($master_is_show_bank_field) : ?>
        <fieldset>
            <legend> Bank Information </legend>
            
              <div class="form-group required">
                <label class="col-md-4 control-label">Account No.</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input  name="account_number" id="account_number" type="text" required="required" maxlength="100" class="form-control" >
                    </div>
                </div>
            </div>
            
            <div class="form-group required">
                <label class="col-md-4 control-label">IFSC Code</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input  name="ifsc" id="ifsc" type="text" required="required" maxlength="100" class="form-control" >
                    </div>
                </div>
            </div>
            
            <div class="form-group required">
                <label class="col-md-4 control-label">Account Type</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-home"></i></span>
                        <select name="account_type" id="account_type" class="form-control">
                            <option value="" disabled="">Select Account Type</option>
                            <option value="saving" >Saving</option>
                            <option value="current" >Current</option>
                        </select>
                    </div>
                </div>
            </div>
                        
              <div class="form-group required">
                <label class="col-md-4 control-label">Account Holder Name</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input  name="account_holder_name" id="account_holder_name" type="text" required="required" maxlength="100" class="form-control" >
                    </div>
                </div>
            </div>
            
              <div class="form-group required">
                <label class="col-md-4 control-label">Bank Name</label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                        <input  name="bank_name" id="bank_name" type="text" required="required" maxlength="100" class="form-control" >
                    </div>
                </div>
            </div>
            
            <!--........................................................................................................................-->
            <!--              <div class="form-group required">-->
            <!--    <label class="col-md-4 control-label">G Pay/Phone Pay</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>-->
            <!--            <input  name="g_pay" id="g_pay" type="text" required="required" maxlength="100" class="form-control" >-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
            
            
            <!--              <div class="form-group required">-->
            <!--    <label class="col-md-4 control-label">PhonePe</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>-->
            <!--            <input  name="phone_pay" id="phone_pay" type="text" required="required" maxlength="100" class="form-control" >-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
            
            
            <!--              <div class="form-group required">-->
            <!--    <label class="col-md-4 control-label">Paytm</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>-->
            <!--            <input  name="paytm" id="paytm" type="text" required="required" maxlength="100" class="form-control" >-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
            
            <!--               <div class="form-group required">-->
            <!--    <label class="col-md-4 control-label">UPI ID</label>-->
            <!--    <div class="col-md-6  inputGroupContainer">-->
            <!--        <div class="input-group"> <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>-->
            <!--            <input  name="upi_id" id="upi_id" type="text" required="required" maxlength="100" class="form-control" >-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
            
            
        </fieldset>
         <?php endif; ?>
        
        <!--Term & Condition check Box-->
          <div class="form-group">
                <label class="col-md-4 control-label"></label>
                <div class="col-md-6  inputGroupContainer">
                    <div class="input-group"> 
                        <input style="margin: 3px 20px 0" type="checkbox" name="agree" value="true" required="required" />I Agree <a href="terms_and_conditions.php" style="color:#09F;" target="_blank">Term & Condition</a>
                    </div>
                </div>
            </div>
        
        <!-- Button -->
        <div class="form-group">
            <label class="col-md-4 control-label"></label>
            <div class="col-md-4">
                <button name="submit" type="submit" id="submit" onclick="return confirm('Are you sure for register');" class="btn btn-danger" >Submit </button>
            </div>
        </div>
    </form>
</div>
<script type="text/javascript">
    var master_is_paid_register = <?php echo $master_is_paid_register ? 'true' : 'false'; ?>;
    var master_is_user_id_field_auto = <?php echo $master_is_user_id_field_auto ? 'true' : 'false'; ?>;
var master_is_show_pan_field = <?php echo $master_is_show_pan_field ? 'true' : 'false'; ?>;
var master_is_show_aadhar_no_field = <?php echo $master_is_show_aadhar_no_field ? 'true' : 'false'; ?>;
var master_is_unique_email_field = <?php echo $master_is_unique_email_field ? 'true' : 'false'; ?>;
var master_is_unique_mobile_field = <?php echo $master_is_unique_mobile_field ? 'true' : 'false'; ?>;
var master_is_placement_id_field = <?php echo $master_is_placement_id_field ? 'true' : 'false'; ?>;
var master_is_pin_system = <?php echo $master_is_pin_system ? 'true' : 'false'; ?>;
var master_project_category = '<?= $master_project_category; ?>';

    // When the document is ready
    $(document).ready(function () {
        $(".datepicker").datepicker({
            dateFormat: "yy-mm-dd",
            changeMonth: true,
            changeYear: true,
            yearRange: "-100:+0",
        });

    });

    function validateForm() {
        var validation_message_list = '';
        var is_form_valid = true;
        if (!check_sponser($("#refer_id").val() ) ) {
            validation_message_list += '<li>Invalid Sponser Id!</li>';
            is_form_valid = false;
        }
        if (master_is_placement_id_field && $("#placement_id").val().trim() && !check_placement($("#placement_id").val()) ) {
            validation_message_list += '<li>Invalid Placement Id!</li>';
            is_form_valid = false;
        }
        if (master_is_paid_register && master_is_pin_system && !check_pin($("#pin_no").val()) ) {
            validation_message_list += '<li>Invalid PIN no.!</li>';
            is_form_valid = false;
        } 
        if (!master_is_user_id_field_auto && !check_login_id($("#login_id").val()) ) {
            validation_message_list += '<li>Invalid User Id!</li>';
            is_form_valid = false;
        }
        if (master_is_unique_email_field && !check_email($("#email").val()) ) {
            validation_message_list += '<li>Invalid Email Id!</li>';
            is_form_valid = false;
        } 
        if (master_is_unique_mobile_field && !check_mobile($("#mobile").val()) ) {
            validation_message_list += '<li>Invalid Mobile no!</li>';
            is_form_valid = false;
        } 
        if (master_is_show_pan_field && !check_pan($("#pan_no").val()) ) {
            validation_message_list += '<li>Invalid PAN!</li>';
            is_form_valid = false;
        } 
        if (master_is_show_aadhar_no_field && !check_aadhar($("#aadhar_no").val()) ) {
            validation_message_list += '<li>Invalid Aadhar no!</li>';
            is_form_valid = false;
        } 
        if( master_is_paid_register && master_project_category == 'CRYPTO' && !is_crypto_currency_transfer_success){
            validation_message_list += '<li>Crypto token transfer is not done!</li>';
        }
        
        if(is_form_valid){
            console.log("Registering please wait...");
            $("#validation_success_message").html("Registering please wait...");
        } else {
            console.log(" validation_message_list "+validation_message_list);
           $("#validation_message_list").html(validation_message_list);  
        }
        $("#validation_message_container").show();
        //$("#validation_message_list").html(is_form_valid ? 'Registering please wait... ' : validation_message_list);
        $("#validation_message_container").focus();
        //$("#refer_id").focus();
        
        return is_form_valid;
    }
  
  
    function check_sponser(refer_id) {
        $("#validation_message_container").hide();
        var returnValue = false;
        $.ajax({
            url: "get_sponser.php",
            data: {'refer_id': refer_id},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#sponser").html('<b style="color:red">Invalid sponser id</b>');
                } else {
                    returnValue = true;
                    $("#sponser").html('<b style="color:green">' + data.name + ' - Valid sponser id</b>');
                    $("#submit").removeAttr("disabled");
                }
            }
        });
        return returnValue;
    }
    function check_placement(placement_id) {
        if(! placement_id.trim()) return true;
        $("#validation_message_container").hide();
        var returnValue = false;
        $.ajax({
            url: "get_placement.php",
            data: {'refer_id': placement_id},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#placement_id_error").html('<b style="color:red">' + data.name +'</b>');
                } else {
                    returnValue = true;
                    $("#placement_id_error").html('<b style="color:green">' + data.name + '</b>');
                    $("#submit").removeAttr("disabled");
                }
            }
        });
        return returnValue;
    }
    function check_pin(pin_no) {
        $("#validation_message_container").hide();
        var returnValue = false;
        $.ajax({
            url: "get_pin.php",
            data: {'pin_no': pin_no},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#pin_error").html('<b style="color:red">Invalid PIN</b>');
                } else {
                    returnValue = true;
                    $("#pin_error").html('<b style="color:green">Valid PIN</b>');
                    $("#submit").removeAttr("disabled");
                }
            }
        });
        return returnValue;
    }

    
    function check_login_id(login_id) {
        $("#validation_message_container").hide();
        var returnValue = false;
        $.ajax({
            url: "get_login_id.php",
            data: {'login_id': login_id},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    $("#submit").attr("disabled", true);
                    $("#login_error").html('<b style="color:red">User id already exist</b>');
                    returnValue = false;
                } else if (login_id.length < 6 || login_id.length > 100) {
                    $("#submit").attr("disabled", true);
                    $("#login_error").html('<b style="color:red">User id min 6 or max 100 characters</b>');
                    returnValue = false;
                } else {
                    $("#login_error").html('<b style="color:green">Valid user id</b>');
                    $("#submit").removeAttr("disabled");
                    returnValue = true;
                }
            }
        });
        return returnValue;
    }
    function check_mobile(mobile) {
        $("#validation_message_container").hide();
        pattern = /^[0-9]+$/;
        var returnValue = false;
        if(master_is_unique_mobile_field){
           $.ajax({
            url: "get_mobile.php",
            data: {'mobile': mobile},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    $("#submit").attr("disabled", true);
                    $("#mobile_error").html("<b style='color:red'>Mobile already exist</b>");
                    returnValue = false;
                } else if (mobile.length != 10) {
                    $("#submit").attr("disabled", true);
                    $("#mobile_error").html("<b style='color:red'>Mobile must be 10 digit</b>");
                    returnValue = false;
                } else if (!pattern.test(mobile)) {
                    $("#submit").attr("disabled", true);
                    $("#mobile_error").html("<b style='color:red'>Mobile must contain only numbers</b>");
                    returnValue = false;
                } else {
                    $("#mobile_error").html(" <b style='color:green'> Valid mobile number </b>");
                    $("#submit").removeAttr("disabled");
                    returnValue = true;
                }
            }
        }); 
        }
        
        return returnValue;
    }
    function check_email(email) {
        $("#validation_message_container").hide();
//        pattern = /^([a-zA-Z0-9_.-])+@([a-zA-Z0-9_.-])+\.([a-zA-Z])+([a-zA-Z])+/;
        var returnValue = false;
        if(master_is_unique_email_field){
           $.ajax({
            url: "get_email.php",
            data: {'email': email},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#email_error").html("<b style='color:red'>Email id already axist</b>");
                } else {
                    returnValue = true;
                    $("#email_error").html("<b style='color:green'>Valid email id</b>");
                    $("#submit").removeAttr("disabled");
                }
            }
        }); 
        }
        
        return returnValue;
    }
    function check_pan(pan_no) {
        $("#validation_message_container").hide();
        var returnValue = false;
        $.ajax({
            url: "get_pan.php",
            data: {'pan_no': pan_no},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#pan_no_error").html('<b style="color:red">Invalid PAN id</b>');
                } else {
                    returnValue = true;
                    $("#pan_no_error").html('<b style="color:green">Valid PAN</b>');
                    $("#submit").removeAttr("disabled");
                }
            }
        });
        return returnValue;
    }
    function check_aadhar(aadhar_no) {
        $("#validation_message_container").hide();
        var returnValue = false;
        $.ajax({
            url: "get_aadhar.php",
            data: {'aadhar_no': aadhar_no},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#aadhar_no_error").html('<b style="color:red">Invalid Aadhar number</b>');
                } else {
                    returnValue = true;
                    $("#aadhar_no_error").html('<b style="color:green">Valid  Aadhar number</b>');
                    $("#submit").removeAttr("disabled");
                }
            }
        });
        return returnValue;
    }
    
    function check_confirm_password(){
       if ($("#password").val() == $("#confirm_password").val()) {
           $("#confirm_password_error").html('<b style="color:green">password matched</b>');
           $("#submit").removeAttr("disabled");
        } else {
            $("#confirm_password_error").html('<b style="color:red">password is not matcheded</b>');
            $("#submit").attr("disabled", true);
        } 
    }
   
</script>
<section class="bg_default small_pt small_pb">
    <!--	<div class="container">
            
        </div>-->
</section>
<?php include './footer.php'; ?>
