<?php
$title = "Single Leg Report Report";
include 'header.php';
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Single Leg Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Reports</a></li>
                    <li class="breadcrumb-item active">Single Leg Report Report</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="login_id"> UserId: </label>
                                <select name="leg_direction" id="leg_direction" class="form-control">
                            <option value="downline" selected>Downline</option>
                            <option value="upline">Upline</option>
                            <!--                                    <option value="2">Binary Pair Income</option>
                                                                <option value=5>Income on Income</option>-->
                        </select>
                            </div>&nbsp;&nbsp;
                           
                            
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>
                    <table class="table table-striped table-bordered table-hover dt-responsive" id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                        <thead>
                            <tr>
                                <th>S.No.</th>
                                <th>User</th>
                                <th>Datetime</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-right">Total</td>
                                <td class="text-left" id="tfootTotal">  </td>
                                
                            </tr> 
                        </tfoot>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "report/report_single_leg_simple_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function (json) {
                    $("#tfootTotal").text(json.total);
                    return json.data;
                },
            },
            "paging":   false,
            "processing": true,
            "serverSide": true,
            "pageLength": 20,
            "lengthMenu": [[20], [20]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "user_name"},
                // {"data": "pv_amount"},
                {"data": "datetime"},
            ],
        });
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });



</script> 
<?php include 'footer.php'; ?>