<?php
$title = "Invoice Report";
include 'header.php';

//$useridMAINN=$_SESSION['userid'];
?>
<!--<script src="../js/jquery-ui.js" type="text/javascript"></script>-->
<!--<link rel="stylesheet" href="../css/jquery-ui.css" />-->
<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Invoice report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Reports</a></li>
                    <li class="breadcrumb-item active">Invoice Report</li>

                </ol>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-20">
                <div class="card-body">

                    
                    <form class="form-inline" id="search-form" >
                            <div class="form-group " >
                                <label class="form-control" for="from_date"> From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date"  id="from_date" autocomplete="off">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control"  for="to_date"> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date"  id="to_date" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>

                    <table class="table mb-0 table-bordered table-striped" id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>S.No.</th>
                                <th>Invoice Number</th>
                                <th>Invoice Date</th>
                                <th>Customer Name</th>
                                <th>Total</th>
                                <th>Total P.V.</th>
                                <th>Create Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="4" class="text-right">Total</td>
                                <td class="text-left" id="tfootTotal1">  </td>
                                <td colspan="2" class="text-left" id="tfootTotal">  </td>
                                <td></td>
                            </tr> 
                        </tfoot>
                    </table>
                    <?php //echo $pager->renderFullNav();        ?>  
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!--table content ends here-->
</div>
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "report/report_invoice_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function (json) {
                    $("#tfootTotal").text(json.total);
                    $("#tfootTotal1").text(json.total_pv);
                    return json.data;
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "invoice_number"},
                {"data": "invoice_date"},
                {"data": "user_name"},
                {"data": "total"},
                {"data": "total_pv_amount"},
                {"data": "create_datetime"},
                {"data": "invoice_number",
                      "render": function (data, type, full, meta) {
                        return '<a href="view_invoice.php?id=' + full.id + '">View</a>';
                    }
                },

            ],
        }
        );
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });


</script>
<?php
include('footer.php');
?>