<?php
$title = "BBPS Report";
include 'header.php';
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">BBPS Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">BBPS System</a></li>
                    <li class="breadcrumb-item active">BBPS Report</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="txn_type">BBPS Type: </label>
                                <select name="bbps_type" id="txn_type" class="form-control">
                                    <option value="">All</option>
                                    <option value="electric_bill">Electric Bill</option>
                                    <!--<option value="gas_bill">Gas Bill</option>-->
                                    <!--<option value="water_bill">Water Bill</option>-->
                                    <!--<option value="landline_bill">Landline Bill</option>-->
                                </select>
                            </div>&nbsp;&nbsp;
                            <!--<div class="form-group " >-->
                            <!--    <label class="form-control" for="from_date"> From Date: </label>-->
                            <!--    <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date"  id="from_date" autocomplete="off">-->
                            <!--</div>&nbsp;&nbsp;-->
                            <!--<div class="form-group">-->
                            <!--    <label class="form-control"  for="to_date"> To date: </label>-->
                            <!--    <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date"  id="to_date" autocomplete="off" >-->
                            <!--</div>&nbsp;&nbsp;-->
                            <!--<div class="form-group">-->
                            <!--    <label class="form-control" for="status">Closing Status: </label>-->
                            <!--    <select name="status" id="status" class="form-control">-->
                            <!--        <option value="">All</option>-->
                            <!--        <option value="1">Closed</option>-->
                            <!--        <option value="0">Not Closed</option>-->
                            <!--    </select>-->
                            <!--</div>&nbsp;&nbsp;-->
                            <!--<div class="form-group">-->
                            <!--    <label class="form-control" for="payment_status">Payment Status: </label>-->
                            <!--    <select name="payment_status" id="payment_status" class="form-control">-->
                            <!--        <option value="">All</option>-->
                            <!--        <option value="PAID">PAID</option>-->
                            <!--        <option value="UNPAID">UNPAID</option>-->
                            <!--        <option value="PARTIALLY PAID">PARTIALLY PAID</option>-->
                            <!--    </select>-->
                            <!--</div>&nbsp;&nbsp;-->
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>
                    <table class="table table-striped table-bordered table-hover dt-responsive" id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                        <thead>
                            <tr>
                            <tr>
                                <th>S.No.</th>
                                <th>Amount</th>
                                <th>BBPS Type</th>
                                <th>Operator</th>
                                <th>Bill Number</th>
                                <th>Mobile Number</th>
                                <th>Status</th>
                                <th>Datetime</th>
                                <th>Api Response</th>
                            </tr>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <!--<tfoot>-->
                        <!--    <tr>-->
                        <!--        <td colspan="1" class="text-right">Total</td>-->
                        <!--        <td colspan="7" class="text-left" id="tfootTotal">  </td>-->
                        <!--    </tr> -->
                        <!--</tfoot>-->
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "report/bbps_report_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                // "dataSrc": function (json) {
                //     $("#tfootTotal").text(json.total);
                //     return json.data;
                // },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "amount"},
                {"data": "bbps_type"},
                {"data": "operator"},
                {"data": "bill_number"},
                {"data": "mobile_number"},
                {"data": "txn_status"},
                {"data": "datetime"},
                {"data": "response"},
            ],
        });
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });



</script> 
<?php include 'footer.php'; ?>

