<?php
$title = "Users List";
include 'header.php';
?>
<!---new table--->

<div class="container-fluid scrollmenu"  >
<?php echo getMessage(); ?>

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Users List</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Users</a></li>
                    <li class="breadcrumb-item active">Users List</li>

                </ol>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-15">
            <div class="card m-b-20 scrolling-wrapper">
                <div class="card-body">
                    <form class="form-inline" id="search-form" action="">
                        <div class="form-group " >
                            <label class="form-control" for="login_id"> User Id: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter login id" name="login_id">
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control " > From Date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                        </div>&nbsp;&nbsp;
                        <div class="form-group">
                            <label class="form-control "> To date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control" for="name"> Name: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter name" name="name">
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control" for="account_no"> Account No: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter account number" name="account_no">
                        </div>&nbsp;&nbsp;

                        <!--<label class="form-control" for="hold_payment"> Income Type: </label>-->
                        <select name="hold_payment" id="income_type" class="form-control">
                            <option value="">All Payment User</option>
                            <option value="0">Active Payment</option>
                            <option value="1">Hold Payment</option>
                            <!--                                    <option value="2">Binary Pair Income</option>
                                                                <option value=5>Income on Income</option>-->
                        </select>&nbsp;&nbsp;
                           <select name="is_paid" id="is_paid" class="form-control">
                            <option value="">All User</option>
                            <option value="1">Activate User</option>
                            <option value="0">InActivate User</option>
                            <!--                                    <option value="2">Binary Pair Income</option>
                                                                <option value=5>Income on Income</option>-->
                        </select>&nbsp;&nbsp;
                        <!--<label class="form-control" for="status"> Income Type: </label>-->
                        <select name="status" id="status" class="form-control">
                            <option value="">All Status User</option>
                            <option value="0">Active User</option>
                            <option value="1">Blocked User</option>
                            <!--                                    <option value="2">Binary Pair Income</option>
                                                                <option value=5>Income on Income</option>-->
                        </select>&nbsp;&nbsp;

                        <button type="submit" class="btn btn-primary" id="submit">Search</button><br><br><br>
                    </form>

                    <table class="table mb-0 table-bordered table-striped" id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>User Id</th>
                                <th>Name</th>
                                <th>Sponsor</th>
                                <th>Register Date</th>
                                <th>Account No.</th>
                                <th>Plan Id</th>
                                <th>Mobile</th>
                                <!--<th>Payout</th>-->
                                <!--<th>Type</th>-->
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                    <?php //echo $pager->renderFullNav();      ?>  
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!--table content ends here-->
</div>

<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "./report/users_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {

                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;

                    });
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 100,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "name",
                    "render": function (data, type, full, meta) {
                        return '<a href="edit_profile.php?uid=' + full.uid + '">' + full.login_id + '</a>';
                    }},
                /* { "data": "parentRoleId" }, */
                {"data": "name",
                    "render": function (data, type, full, meta) {
                        return '<a href="user_login_process.php?uid=' + full.uid + '" title="Login this user" target="_blank">' + full.name + '</a>';
                    }},
                {"data": "refer_login_id"},
                {"data": "reg_date"},
                {"data": "account_no"},
                {"data": "plan_type"},
                {"data": "mobile"},
//                {"data": "payout"},
//                {"data": "binary_type"},
//                  {"data": "board_type"},
//                  {"data": "club_type"},  
//                {"data": "binary_level"},
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        var btnHTML = '<button onclick="processBlock(' + full.uid + ',\'' + full.login_id + '\',' + full.status + ');" class="btn btn-primary" style="margin:2px;">' + (full.status == 0 ? 'Block' : 'UnBlock') + '</button><br/>'
                                + '<button onclick="processFieldUpdate(' + full.uid + ', \'' + full.login_id + '\' , \'hold_payment\' ,' + (full.hold_payment == 0 ? 1 : 0) + ');" class="btn btn-primary" style="margin:2px;">' + (full.hold_payment == 0 ? 'Hold Payment' : 'Unhold Payment') + '</button>';
                                + '<button onclick="processFieldUpdate(' + full.uid + ', \'' + full.login_id + '\' , \'is_paid\' ,' + (full.is_paid == 0 ? 1 : 0) + ');" class="btn btn-primary" style="margin:2px;">' + (full.is_paid == 0 ? 'Activate User' : 'InActivate User') + '</button>';

                               // + '<button onclick="processFieldUpdate(' + full.uid + ', \'' + full.login_id + '\' , \'block_task\' ,' + (full.block_task == 0 ? 1 : 0) + ');" class="btn btn-primary" style="margin:2px;">' + (full.block_task == 0 ? 'Block Growth' : 'Un-Block Growth') + '</button>';

                        return  btnHTML;
                    }
                },
            ],
        }
        );
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });

        table.on('xhr', function () {
            start = table.ajax.json().start;

        });
    });


    function processBlock(uid, login_id, status) {
        var r = confirm("Do you want Block user ID " + login_id);
        var url = status == 0 ? "process_block.php" : "process_unblock.php";

        if (r) {
            $.get(url, {'uid': uid}, function (data) {
                alert(data);
                location.reload();
            });
        }
    }
    /*function processUnblock(uid, login_id) {
     var r = confirm("Do you want Unblock user ID " + login_id);
     if (r) {
     $.get("process_unblock.php", {'uid': uid}, function (data) {
     alert(data);
     location.reload();
     });
     }
     }*/

    function processFieldUpdate(uid, login_id, field_name, field_value) {
        var r = confirm("Do you want to update status of this id " + login_id);
        if (r) {
            $.get("process_field_update.php", {table_name: 'user', where_field_name: 'uid', id: uid, field_name: field_name, field_value: field_value}, function (data) {
                alert(data);
                location.reload();
            });
        }
    }
//    function searchform(){
//        table.ajax.reload();
//    }
</script>
<?php include 'footer.php'; ?>