<?php
$title = "Top Receiver Report";
include 'header.php';
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Top Receiver</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Income</a></li>
                    <li class="breadcrumb-item active">Top Receiver</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group " >
                                <label class="form-control " > From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control "> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                              <div class="form-group">
                                <label class="form-control "> uid: </label>
                                <input type="text" class="form-control"  placeholder="Enter uid" name="login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
<!--                            <div class="form-group">
                                <label class="form-control" for="income_type"> Income Type: </label>
                                <select name="income_type" id="income_type" class="form-control">
                                   <option value="">Select</option>
                                    <option value="1">Direct Referral</option>
                                    <option value=3>Binary Matching</option>
                                    <option value="7">Upline Income</option>
                                    <option value="5">Leadership Income</option>
                                </select>
                            </div>&nbsp;&nbsp;-->
                            <!--                                                    <div class="form-group">
                                                                                    <label for=""> Name: </label>
                                                                                    <input type="name" class="form-control" id="name" placeholder="Enter name" name="name">
                                                                                </div>-->

                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>
                    <table class="table table-striped table-bordered table-hover " id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                        <thead>
                            <tr>
                                <th>S.No.</th>
                                <th>User</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-right">Total</td>
                                <td colspan="1" class="text-left" id="tfootTotal">  </td>
                            </tr> 
                        </tfoot>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
    var start;
    var txn_type = '<?php echo isset($_GET['txn_type']) ? tres($_GET['txn_type']) : ''; ?>';
    $(document).ready(function () {
        if(txn_type){
            $("#txn_type").val(txn_type);
        }
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                url : "./report/report_top_receiver_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function (json) {
                    $("#tfootTotal").text(json.total);
                    return json.data;
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 50,
            "lengthMenu": [[50], [50]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "user_name"},
                {"data": "amount"},
               

            ],
        });
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });



</script> 

<?php include 'footer.php'; ?>