<?php
$title = "Binary ID Status Report";
include 'header.php';
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Binary ID Status Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Reports</a></li>
                    <li class="breadcrumb-item active">Binary ID Status Report</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="login_id"> UserId: </label>
                                <input type="text" class="form-control"  placeholder="Enter uid" name="login_id" id="login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group " >
                                <label class="form-control" for="from_date"> From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date"  id="from_date" autocomplete="off">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control"  for="to_date"> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date"  id="to_date" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="login_id"> From UserId: </label>
                                <input type="text" class="form-control"  placeholder="Enter uid" name="from_login_id" id="login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="login_id"> Position: </label>
                                <select class="form-control" id="position" name="position">
                                    <option value="">All</option>
                                    <option value="L">Team-L</option>
                                    <option value="R">Team-R</option>
                                </select>
                            </div>&nbsp;
<!--                            <div class="form-group">
                                <label class="form-control" for="name"> Name: </label>
                                <input type="name" class="form-control" id="name" placeholder="Enter name" name="name">
                            </div>&nbsp;&nbsp;-->
                            <div class="form-group">
                                <label class="form-control" for="status">Status: </label>
                                <select name="status" id="status" class="form-control">
                                    <option value="">All</option>
                                    <option value="4">Carry Id</option>
                                    <option value="0">Income</option>
                                    <option value="1">Deduction</option>
                                    <option value="2">Capping</option>
                                    <option value="3">Before Topup</option>
                                </select>
                            </div>&nbsp;&nbsp;
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>
                    <table class="table table-striped table-bordered table-hover " id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                        <thead>
                            <tr>
                            <tr>
                                <th>S.No.</th>
                                <th>User</th>
                                <th>From User</th>
                                <th>Position</th>
                                <th>Datetime</th>
                                <th>Status</th>
                            </tr>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "report/report_binary_id_status_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
//                "dataSrc": function (json) {
                    //$("#tfootTotal").text(json.total);
                    //return json.data;
//                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "user_name"},
                {"data": "from_user_name"},
                {"data": "position"},
                {"data": "datetime"},
                {"data": "status"},
            ],
        });
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        table.on('xhr', function () {
            start = table.ajax.json().start;
        });
    });



</script> 
<?php include 'footer.php'; ?>