<?php
$title = "Admin Login Details";
include 'header.php';
?>
<div class="container-fluid">
    <?php echo getMessage(); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Admin Login Report</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Admin Settings</a></li>
                    <li class="breadcrumb-item active">Admin Login Details</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <div class="card-body">
                        <form class="form-inline" id="search-form" >
                            <div class="form-group">
                                <label class="form-control" for="login_id"> UserId: </label>
                                <input type="text" class="form-control"  placeholder="Enter uid" name="login_id" id="login_id" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group " >
                                <label class="form-control" for="from_date"> From Date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date"  id="from_date" autocomplete="off">
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control"  for="to_date"> To date: </label>
                                <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date"  id="to_date" autocomplete="off" >
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="ip"> IP: </label>
                                <input type="text" class="form-control" id="ip" placeholder="Enter name" name="ip" />
                            </div>&nbsp;&nbsp;
                            <div class="form-group">
                                <label class="form-control" for="status">Status: </label>
                                <select name="status" id="status" class="form-control">
                                    <option value="">All</option>
                                    <option value="1">Success</option>
                                    <option value="0">Failed</option>
                                </select>
                            </div>&nbsp;&nbsp;
                            <button type="submit" class="btn btn-primary">Search</button>
                        </form>
                    </div>
                    <table class="table table-striped table-bordered table-hover " id="datatable-ajax-page" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>User</th>
                                <th>IP Address</th>
                                <th>Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->



</div> <!-- container-fluid -->
<script type="text/javascript">
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "./report/report_admin_login_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
            },
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                
                {"data": "user"},
                {"data": "datetime"},
                {"data": "ip"},
                {"data": "status"},
            ],
        }
        );

        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });

        table.on('xhr', function () {
            start = table.ajax.json().start;

        });
    });



</script> 

<?php include 'footer.php'; ?>