<?php
$title = "Payment Withdrawal Request";
include 'header.php';
?>
<!----new table started-->

<div class="container-fluid">

    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Payment Withdrawal Request</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Report</a></li>
                    <li class="breadcrumb-item active">Payment Withdrawal Request</li>
                </ol>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-20">
                <div class="card-body">

                    <form class="form-inline" id="search-form" action="">
                        <div class="form-group " >
                            <label class="form-control" for="login_id"> UserId: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter login id" name="login_id">
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control " > From Date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                        </div>&nbsp;&nbsp;
                        <div class="form-group">
                            <label class="form-control "> To date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                        </div><br>&nbsp;&nbsp;
                        <!--                        <label class="form-control" for="hold_payment"> : </label>-->
                        <select name="hold_payment" id="income_type" class="form-control">
                            <option value="">All Payment User</option>
                            <option value="0">Active Payment</option>
                            <option value="1">Hold Payment</option>
                        </select>&nbsp;&nbsp;
                        <!--                        <label class="form-control" for="status"> </label>-->
                        <select name="status" id="income_type" class="form-control">
                            <option value="">All Status User</option>
                            <option value="0">Active User</option>
                            <option value="1">Blocked User</option>

                        </select>&nbsp;&nbsp;

                        <button type="submit" class="btn btn-primary" id="submit">Search</button><br><br><br>
                    </form>

                    <form action="./payout_multiple_withdrawal.php" method="post">
                    <table class="table table-striped table-bordered mb-0" id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th><input type="checkbox"  onchange="checkUncheckAllPayout(this)"/></th>
                                <th>User</th>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>TDS (<?php echo $master_tds_rate; ?>%)</th>
                                <th>Service Charge (<?php echo $master_service_rate; ?>%)</th>
                                <th>Net Amount</th>
                                <th>Details</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
<!--                           <tr>
                <th colspan="3" style="text-align: right;">Total Amount:</th>
              <th colspan="3" style="text-align: left;">Rs. <?php echo $total ?></th>
              <th colspan="2" style="text-align: left;">Rs. <?php echo $net_total ?></th>
            </tr>-->
                    </table>
                    <h3>Multiple Payout</h3>
                    <div class="form-group row">
                        <label for="description" class="col-sm-2 col-form-label">Payment description<span>*</span></label>
                        <input type="text" class="form-control" name="description" id="uid" required="required" maxlength="255"  style="width:300px;" >
                    </div>
                    <div class="form-group">
                        <div>
                            <button name="submit" type="submit" id="submit" value="Submit" class="btn btn-primary waves-effect waves-light">Submit</button>
                        </div>
                    </div>
                </form>    
                
                </div>
            </div>
        </div> <!-- end col -->

    </div>
    <!--table content ends here-->

</div>

<div id="commonModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title mt-0" id="myModalLabel">Payment Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body">
                <form class="form-horizontal" action="./process_payout_withdraw.php" method="POST" onsubmit="return confirm('Are you sure? You want to update payment details!')">
                    <table class="table table-striped">
                        <tbody>
                            <tr >
                                <td>Name</td>
                                <td id="name"></td>
                            </tr>
                            <tr >
                                <td>Email</td>
                                <td id="email"></td>
                            </tr>
                            <tr>
                                <td>Mobile</td>
                                <td id="mobile"></td>
                            </tr>
                        </tbody>
                    </table>

                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th colspan="2" style="text-align: left;">Bank Details</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Account Holder Name</td>
                                <td id="account_holder_name"></td>
                            </tr>
                            <tr>
                                <td>Bank Name</td>
                                <td id="bank_name"></td>
                            </tr>
                            <tr >
                                <td>Branch Name</td>
                                <td id="branch_name"></td>
                            </tr>
                            <tr >
                                <td>Account Number</td>
                                <td id="account_number"></td>
                            </tr>
                            <tr >
                                <td>IFSC Code</td>
                                <td id="ifsc"></td>
                            </tr>
                        </tbody>
                    </table>
                    <div>
                        <input type="hidden" name="recid" id="withdraw_recid" value=""/>
                        <input type="hidden" name="amount" id="withdraw_amount" value=""/>
                        <textarea id="withdraw_description" name="description" rows="7" cols="60" placeholder="Enter Bank Transaction Details" ></textarea>
                        <br/>
                        <div class="modal-footer">
                            <div class="col-md-offset-3">
                                <button  class="btn btn-primary" name="submit">Update Transaction Details</button>
                                <button class="btn btn-default " data-dismiss="modal">Cancel</button>
                            </div>
                        </div>
                    </div>

                </form>
            </div>

            <form class="form-horizontal" id="search-modal-form">
                <div id="searchModalFormField">
                </div>

            </form>
        </div>
        <!--                                                            <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Close</button>
                                                                        <button type="button" class="btn btn-primary waves-effect waves-light">Save changes</button>
                                                                    </div>-->
    </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->
<!--</div>-->
<script type="text/javascript">
    var master_is_payout_withdraw_request_reject = <?php echo $master_is_payout_withdraw_request_reject ? 'true' : 'false'; ?>;
    var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "./report/payout_withdraw_request_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
            },
            "columnDefs": [
                { "orderable": false, "targets": 1 }
            ],
            "processing": true,
            "serverSide": true,
            "pageLength": 500,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        return '<input type="checkbox" name="uid_array[]" value="'+full.uid+'" class="uid_checkbox" >';
                    }
                },
                {"title": "User", "data": "name",
                    "render": function (data, type, full, meta) {
                        return full.name + ' (' + full.login_id + ')';
                    }},
                /* { "data": "parentRoleId" }, */
                {"data": "datetime"},
                {"data": "amount"},
                {"data": "tds"},
                {"data": "service"},
                {"data": "net_amount"},
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        var html = '<button onclick="processStatus(' + full.recid + ', \'' + full.description + '\', \'' + full.name + '\', \'' + full.email + '\', \'' + full.mobile + '\', \'' + full.account_holder_name + '\', \'' + full.bank_name + '\', \'' + full.branch_name + '\', \'' + full.account_number + '\', \'' + full.ifsc + '\',' + full.amount + ');" class="btn btn-primary">' + 'View Pay Details' + '</button> ';
                        if(master_is_payout_withdraw_request_reject){
                            html += '<br/><a href="javascript:;" onclick="rejectWithdrawRequest(' + full.recid + ', ' + full.uid + ', \'' + full.login_id + '\',  \'' + full.name + '\', ' + full.amount + ');" class="btn btn-danger">Reject</a>';
                        }
                        return html;
                    }
                }
                
            ],
        }
        );

        $("#search-form").submit(function (e) {
            table.ajax.reload();
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });

        table.on('xhr', function () {
            start = table.ajax.json().start;

        });
    });




    function processStatus(recid, description, name, email, mobile, account_holder_name, bank_name, branch_name, account_number, ifsc, amount) {
        $("#withdraw_recid").val(recid);
        $("#withdraw_amount").val(amount);
        $("#withdraw_description").val(description);

        $("#name").text(name);
        $("#email").text(email);
        $("#mobile").text(mobile);
        $("#account_holder_name").text(account_holder_name);
        $("#bank_name").text(bank_name);
        $("#branch_name").text(branch_name);
        $("#account_number").text(account_number);
        $("#ifsc").text(ifsc);


        $('#commonModal').modal();
    }
    
    function checkUncheckAllPayout(thisObj) {
        if ($(thisObj).is(':checked')) {
            $(".uid_checkbox").prop('checked', true);
        } else {
            $(".uid_checkbox").prop('checked', false);
        }



    }
    
    function rejectWithdrawRequest(recid, uid, login_id, name, amount){
        var r = confirm("Caution! You are about to reject withdrawal request from "+name+" ("+login_id+") of amount "+amount+". Are you sure about it? ");
        if (r) {
            $.ajax({
                url: "payout_reject_withdraw_request.php",
                type: 'post',
                data: {'recid': recid, 'uid': uid},
                dataType: 'json',
                async: false,
                success: function (result) {
                    if (result.is_success) {
                        alert("Withdraw request rejected successfully");
                        location.reload();
                    } else {
                        alert(result.error_message);
                    }
                }
            });
        }
    }


</script>
<?php include 'footer.php'; ?>