<?php
$title = "Payout Report";
include 'header.php';
?>

<div class="container-fluid">

    
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Payment Withdrawal Request</h4>
                <ol class="breadcrumb">
                      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Payments</a></li>
                    <li class="breadcrumb-item active">Payment Withdrawal Request</li>
                </ol>

            
            </div>
        </div>
    </div>
    <?php if ($master_project_category == 'CRYPTO' && $master_payment_method == 'WITHDRAWAL_CRYPTO') {                
            include_once './payout_withdraw_request_crypto_content.php'; } 
            ?>
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <!--<div class="card-body">-->
                    <?php echo getMessage(); ?>
                    <div class="card-body">
                        <form class="form-inline" id="search-form" action="">
                        <div class="form-group " >
                            <label class="form-control" for="login_id"> UserId: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter login id" name="login_id">
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control" for="name"> User Name: </label>
                            <input type="text" class="form-control" id="login_id" placeholder="Enter name" name="name">
                        </div>&nbsp;&nbsp;
                        <div class="form-group " >
                            <label class="form-control " > From Date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="From date" name="from_date" autocomplete="off">
                        </div>&nbsp;&nbsp;
                        <div class="form-group">
                            <label class="form-control "> To date: </label>
                            <input type="text" class="form-control datepicker"  placeholder="To date" name="to_date" autocomplete="off" >
                        </div>&nbsp;&nbsp;
                        
                            <div class="form-group">
                        <label class="form-control" for="status">Status </label>
                        <select name="status" id="income_type" class="form-control">
                            <option value="">All Status User</option>
                            <option value="0">Active User</option>
                            <option value="1">Blocked User</option>
                                                               
                        </select>&nbsp;&nbsp;
                            </div>

                        <button type="submit" class="btn btn-primary" id="submit">Search</button><br><br><br>
                    </form>
                    <!--</div>-->
                    <form action="./payout_multiple_withdrawal.php" method="post" id="payout_form">
                        <input type="hidden"  name="txn_type_m" id="txn_type_m"  >
                    <table class="table table-striped table-bordered table-hover " id="datatable-ajax-page">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th><input type="checkbox"  onchange="checkUncheckAllPayout(this)"/></th>
                                 <th>Action</th>
                                <th>User</th>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>TDS (<?php echo $master_tds_rate; ?>%)</th>
                                <th>Service Charge (<?php echo $master_service_rate; ?>%)</th>
                                <th>Net Amount</th>
                                <th>Account</th>
                               
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="5" class="text-right">Total</th>
                                <th id="tfootTotal1" class="text-left"></th>
                                <th id="tfootTotal2" class="text-left"></th>
                                <th id="tfootTotal3" class="text-left"></th>
                                <th id="tfootTotal4" class="text-left"></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                        <!--<div class="card-body">-->
                    <h3>Multiple Payout</h3>
                    <div class="form-group">
                        <label for="description" class="col-sm-6 col-form-label">Payment description<span>*</span></label>
                        <input type="text" class="form-control" name="description" id="description" required="required" maxlength="255"  style="width:300px;" >
                    </div>
                    <div class="form-group">
                        <div>
                            <button name="submit" type="submit" id="submit" value="Submit" class="btn btn-primary waves-effect waves-light">Submit</button>
                        </div>
                    </div>
                        <!--</div>-->
                </form>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
    </div>


<script type="text/javascript">
var master_is_payout_withdraw_request_reject = <?php echo $master_is_payout_withdraw_request_reject ? 'true' : 'false'; ?>;
var master_payment_method = '<?=$master_payment_method?>';
 var start;
    $(document).ready(function () {
        var table = $('#datatable-ajax-page').DataTable({
            "ajax": {
                "url": "./report/payout_withdraw_request_json.php",
                "type": "POST",
                dataType: 'json',
                data: function (d) {
                    var formData = $("#search-form").serializeArray();
                    $.each(formData, function (i, field) {
                        d[field.name] = field.value;
                    });
                },
                "dataSrc": function ( json ) {
                //Make your callback here.
                //alert("Done! "+json.recordsTotal);
                $("#tfootTotal1").text(json.total);
                    $("#tfootTotal2").text(json.tds_total);
                    $("#tfootTotal3").text(json.service_total);
                    $("#tfootTotal4").text(json.net_total);
                return json.data;
                },
            },
            "columnDefs": [
    { "orderable": false, "targets": 1 }
  ],
            "processing": true,
            "serverSide": true,
            "pageLength": 100,
            //"lengthMenu": [[100, 500, 1000, 2000, -1], [100, 500, 1000, 2000, "All"]],
            "lengthMenu": [[100, 500, 1000, 2000, 5000], [100, 500, 1000, 2000, 5000]],
            "dom": 'B<"top">rt<"bottom"lp><"clear">',
            buttons: [
                'excel', 'csv', 'pdf', 'print'
            ],
            "columns": [
                {"data": "sno"},
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        return '<input type="checkbox" name="uid_array[]" value="'+full.uid+'" class="uid_checkbox" >';
                    }
                },
                {"data": "uid",
                    "render": function (data, type, full, meta) {
                        //var max_amount = master_max_payment_amount_request < full.wallet ? master_max_payment_amount_request : full.wallet;
                        var html = '';
                        if(master_payment_method == 'WITHDRAWAL_CRYPTO'){
                            var htmlBtn = ' <button type="button" class="btn btn-primary" onclick="sendCryptoCurrencyToMember(\'' + full.net_amount+ '\',\'' + full.account_number + '\',' + full.recid + ', ' + full.uid + ', \'' + full.login_id + '\', \'' + full.sno + '\' );" style="margin:2px;" >' + 'Transfer Coin' + '</button>';
                        } else {
                            var htmlBtn = ' <button type="button" class="btn btn-primary" onclick="processStatus(' + full.recid + ', ' + full.uid + ', \'' + full.login_id + '\', \'' + full.sno + '\');" style="margin:2px;" >' + 'Make Payment' + '</button>';
                        }
                        html += '<span id="rowPaymentTD-' + full.sno + '">'
                                +'<input readonly type="number" name="amount_array[' + full.uid + ']" id="amount-' + full.sno + '"  value="'+full.net_amount+'" step=".01" placeholder="Enter Amount" style="margin:2px;" /><br/>'
                                +'<input type="text" name="description" id="description-' + full.sno + '" placeholder="Transaction details" style="margin:2px;" />'
                                + htmlBtn
                                +'</span>';
                        
                        if(master_is_payout_withdraw_request_reject){
                            html += '<br/><a href="javascript:;" onclick="rejectWithdrawRequest(' + full.recid + ', ' + full.uid + ', \'' + full.login_id + '\',  \'' + full.name + '\', ' + full.amount + ');" class="btn btn-danger">Reject</a>';
                        }
                        return html;
                    }
                },    
                {"data": "name",
                    "render": function (data, type, full, meta) {
                        return full.name + ' (' + full.login_id + ')';
                    }},
                /* { "data": "parentRoleId" }, */
                {"data": "datetime"},
                {"data": "amount"},
                {"data": "tds"},
                {"data": "service"},
                {"data": "net_amount"},
                {"data": "account_number"},
                
            ],
        }
        );
        $("#search-form").submit(function (e) {
            table.ajax.reload();
            $('#txn_type_m').val($('#txn_type').val());
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        
        table.on('xhr', function () {
	    start = table.ajax.json().start;

        });
    });
    
//    function bulk_TRX_transfer(){
//        
//       const formData = $('#payout_form').serializeArray();
//       $.each(formData, function(i, field){
//           console.log(field.name + ":" + field.value)
//       });
//        
//    }
//    

    function processStatus(recid, uid, login_id, rowCounter) {
        // $( "#"+domId).dialog( "open" );
        if ($("#description-" + rowCounter).val() == '') {
            alert("Please enter transaction details!");
            return;
        }
        var r = confirm("Do you want make payment of user ID " + login_id);
        if (r) {
            //var txn_type = $("#txn_type").val();
            $.post("process_payout_withdraw.php", {uid: uid, description: $("#description-" + rowCounter).val(), amount: $("#amount-" + rowCounter).val(), recid: recid},
            function (data) {
                var htmlMessage = data.status ? '<span style="color:green">Paid</span>' : '<span style="color:red">ERROR</span>';
                $("#rowPaymentTD-" + rowCounter).html(htmlMessage);
            }, 'json');
        }
    }
    function checkUncheckAllPayout(thisObj) {
        if ($(thisObj).is(':checked')) {
            $(".uid_checkbox").prop('checked', true);
        } else {
            $(".uid_checkbox").prop('checked', false);
        }



    }
    
     function rejectWithdrawRequest(recid, uid, login_id, name, amount){
        var r = confirm("Caution! You are about to reject withdrawal request from "+name+" ("+login_id+") of amount "+amount+". Are you sure about it? ");
        if (r) {
            $.ajax({
                url: "payout_reject_withdraw_request.php",
                type: 'post',
                data: {'recid': recid, 'uid': uid},
                dataType: 'json',
                async: false,
                success: function (result) {
                    if (result.is_success) {
                        alert("Withdraw request rejected successfully");
                        location.reload();
                    } else {
                        alert(result.error_message);
                    }
                }
            });
        }
    }
 
</script>
 
<?php include 'footer.php'; ?>