<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$title = "Franchise Product Sale";
include "header.php";

$fid = 1;
$co = "select f.*, s.* from franchise f LEFT JOIN state s ON f.state = s.state_code where fid = '$fid' ";
$result = mysqli_query($connection, $co);
if (mysqli_num_rows($result) <= 0) {
    echo " <h3> Please Create Company Franchise Id. <br> <a href='./create_franchise.php' class='btn btn-success'> Create franchise </a> </h3>";
    include('footer.php');
    die;
} else {
    $franchise = mysqli_fetch_object($result);
}

?>
<br style="clear: both"/>
<?php
?>


<div class="container-fluid">
    <?php echo getMessage(); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Product Sale from admin to franchise store</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Inventory </a></li>
                    <li class="breadcrumb-item active">Franchise Product Sale</li>
                </ol>
            </div>
        </div>
    </div>

    <!-- end row -->



    <div class="row">

        <div class="col-12">

            <div class="card m-b-20">
                <div class="card-body">
                    <form name="form" id="form" action="franchise_product_sale_bill.php" method="post"  onsubmit="$('#generate_invoice').prop('disabled', true)">
                        <!--                                        <h4 class="mt-0 header-title">Textual inputs</h4>
<p class="text-muted m-b-30">Here are examples of <code class="highlighter-rouge" >.form-control</code> applied to each textual HTML5 <code class="highlighter-rouge">&lt;input&gt;</code> <code class="highlighter-rouge">type</code>.</p>-->
                        <div class="form-group row">
                            <!--  <label for="example-text-input" class="col-sm-2 col-form-label">Text</label>-->
                            <label class="col-sm-2 col-form-label" for="">Franchise ID</label>
<!--      <label class="col-sm-2 col-form-label" for="dob"> Name<span>*</span></label>-->
                            <div class="col-sm-10">
                                <select  class="form-control" name="fid" id="fid_select2" required="required" onChange="is_user_exist(this.value);" >
                                    <option value="" selected="selected">--------Select franchise-------</option>      <!--disabled="disabled" -->
                                    <?php
                                    $rs = mysqli_query($connection, "select fid, store_name, state from franchise where fid != '1' order by store_name ");
                                    while ($row = mysqli_fetch_object($rs)) {
                                        echo "<option value='" . $row->fid . "'>$row->store_name</option>";
                                    }
                                    ?>
                                </select>
                                <span id="user_id"></span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="">Invoice date <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control datepicker"  type="date" name="invoice_date" id="invoice_date"  value="<?php echo date('Y-m-d'); ?>" required="required">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="">Invoice Number <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="invoice_number"  id="invoice_number" value="<?php echo $master_purchase_order_prefix.$franchise->purchase_no; ?>" size="28" required="required">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="">Reference Number </label>
                            <div class="col-sm-10">
                                <input class="form-control" type="text" name="reference_number"  id="reference_number" value="" >
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2  col-form-label" for="">State Details <span></span></label>
                            <div class="col-sm-10 row">
                                <!--<div class="row">-->
                                <div class="col-sm-5">
                                    <p>Company State Code : <span id="cStateCode"><?= $franchise->state_number; ?> </span><br>
                                        Company State Name : <span id="cStateName"><?= $franchise->name; ?> </span> </p>
                                </div>
                                <div class="col-sm-5" style="color:green"><p>Franchise State Code : <span id="fStateCode"> </span> <input type="hidden" name="Shipping_state_code" id="shipping_state_code" > <br>
                                        Franchise State Name : <span id="fStateName"></span> <br> Tax Type : <span id="taxType">GST [INTER STATE]</span>  <input type="hidden" name="Shipping_state_name" id="shipping_state_name" ></p>
                                </div>
                            </div>
                        </div>
                        

                        <div class="form-group row">
                            <table class="table  table-bordered table-light ">
                                <thead>
                                    <tr>
                                        <th class="w-20"> Product Name<span>*</span></th>
                                        <th style="width:100px">HSN/SAC<span>*</span></th>
                                        <!--w-25-->
                                        <th style="width:100px"> Qty <span>*</span></th>
                                        <th style="width:100px"> Rate <span>*</span></th>
                                        <th class="w-5">Tax </th>
                                        <th class="w-5"> Amount <span>*</span></th>
                                        <th style="width:100px"> Action </th>
                                    </tr>    
                                </thead>
                                <tbody id="lineItemBody">

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="0">
                                            <button onclick="addLineItemHTML();" type="button" id="add_products" class="btn btn-primary waves-effect waves-light mb-3">Add Product + </button>

                                        </td>
                                        <!--<tr>-->
                                        <td colspan="3" >
                                            Total P.V.:
                                            <span colspan="2" class="font-weight-bold" id="allItemTotalPVLabel" >0.00</span>
                                        </td>
                                        <td colspan="4"> </td>
                                        <!--</tr>-->
                                    </tr>
                                    <tr>
                                        <td colspan="4" class="text-right">Sub Total </td>
                                        <td colspan="3" class="total-amount font-weight-bold" id="allItemSubTotalLabel" >0.00</td>
                                    </tr>


                                    <tr>
                                        <td colspan="4" class="text-right" id="taxLineItemHtmlLabel">Tax</td>
                                        <td colspan="3" class="font-weight-bold" id="taxLineItemHtmlAmount" >0.00</td>
                                    </tr>
                                    <tr>
                                        <td colspan="4" class="text-right">Total:</td>
                                        <td colspan="3" class="font-weight-bold" id="allItemTotalLabel" >0.00</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="form-group">
                            <div>
                                <input id="generate_invoice"  type="submit" name="submit"  value="Generate Invoice" class="btn btn-primary" />
                            </div>
                        </div>
                    </form>
                    <p> Note: 1st Franchise of franchise list is the company id. So we can't sale to 1st franchise. <br> * this is not showing in above franchise list .</p>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
</div>

<select id="allItemList" class="hidden" style="display: none">
    <option value="">Select Item</option>
    <?php
    $product_rs = mysqli_query($connection, "select `pid`, `pcode`, `pname`, `mrp`, `pv`, `pcost`, `tax_rate`, `gst_tax_id`, `igst_tax_id`, `hsn_code`, (SELECT SUM(s.quantity) FROM `stock` s WHERE s.fid='$fid' AND s.item_id = pid) AS quantity from product order by pname");
    while ($product_row = mysqli_fetch_object($product_rs)) {
        ?>
        <option value="<?= $product_row->pid; ?>" data-pv="<?= $product_row->pv ?>" data-pcost="<?= $product_row->pcost ?>" data-quantity="<?= $product_row->quantity ?>" data-tax_rate="<?= $product_row->tax_rate ?>" data-gst_tax_id="<?= $product_row->gst_tax_id ?>" data-igst_tax_id="<?= $product_row->igst_tax_id ?>" data-hsn_code="<?= $product_row->hsn_code ?>" >
            <?= $product_row->pname . " ($product_row->pcode) "; ?>
        </option>
    <?php } ?>
</select>
<select id="interGstTaxList" class="hidden" style="display: none">
    <option value="">NON-TAXABLE</option>
    <?php
    $result_tax = mysqli_query($connection, "SELECT `id`, `name`, `rate`, `tax_type` FROM `tax` WHERE `tax_type` = 'GST'");
    while ($row_tax = mysqli_fetch_object($result_tax)) {
        ?>
        <option value="<?php echo $row_tax->id; ?>" data-name="<?= $row_tax->name ?>" data-rate="<?= $row_tax->rate ?>" data-tax_type="<?= $row_tax->tax_type ?>" >
            <?php echo $row_tax->name . " ($row_tax->rate%) "; ?>
        </option>
    <?php } ?>
</select>
<select id="intraGstTaxList" class="hidden" style="display: none">
    <option value="">NON-TAXABLE</option>
    <?php
    $result_tax = mysqli_query($connection, "SELECT `id`, `name`, `rate`, `tax_type` FROM `tax` WHERE `tax_type` = 'IGST'");
    while ($row_tax = mysqli_fetch_object($result_tax)) {
        ?>
        <option value="<?php echo $row_tax->id; ?>" data-name="<?= $row_tax->name ?>" data-rate="<?= $row_tax->rate ?>" data-tax_type="<?= $row_tax->tax_type ?>">
            <?php echo $row_tax->name . " ($row_tax->rate%) "; ?>
        </option>
    <?php } ?>
</select>
<!-- end row -->

<?php
$i = 1;
?> 

<script>
    var lineItemIndex = 0;
    var lineItemAmountArray = [];
    var lineItemPVAmountArray = [];
    var lineItemTaxArray = [];
    var itemOptionHTML = $("#allItemList").html();
    var adminStateCode = '<?= $franchise->state_number ?>';
    var tax_exclusive_or_inclusive = '<?= $master_item_tax_exclusive_or_inclusive ?>';
    var isIntraGST = false;

    addLineItemHTML();
    function addLineItemHTML() {
        var taxOptionHTML = isIntraGST ? $("#intraGstTaxList").html() : $("#interGstTaxList").html();
        var lineItemHTML = '<tr id="lineItemRow-' + lineItemIndex + '"> ' +
                '<td><select name="line_item_array[' + lineItemIndex + '][pid]" id="lineItemItemId-' + lineItemIndex + '" onchange="itemDetail(this.id)" data-placeholder="Type or click to select an item." class="form-control select2 item-name" required > ' + itemOptionHTML + '</select>' +
                ' Stock <span id="lineItemStockLabel-' + lineItemIndex + '">0</span><input type="hidden" id="lineItemPV-' + lineItemIndex + '" value="0" /></td>' +
                '<td><span id="lineItemHsnOrSac-' + lineItemIndex + '"></span></td>' +
                '<td><input name="line_item_array[' + lineItemIndex + '][quantity]" id="lineItemQuantity-' + lineItemIndex + '" onchange="updateLineItem(this.id)" value="1.00" class="form-control" type="number" min="0" step=".01" required /></td>' +
                '<td><input name="line_item_array[' + lineItemIndex + '][rate]" id="lineItemRate-' + lineItemIndex + '" onchange="updateLineItem(this.id)" value="0.00" class="form-control" type="number" min="0" step=".01" required /></td>' +
                '<td><select name="line_item_array[' + lineItemIndex + '][tax_id]" id="lineItemTaxId-' + lineItemIndex + '" onchange="updateLineItem(this.id)" class="form-control"  >' + taxOptionHTML + '</select></td>' +
                '<td><span id="lineItemAmount-' + lineItemIndex + '">0.00</span></td>' +
                '<td> <i id="lineItemI-' + lineItemIndex + '" onclick="deleteLineItem(this.id)" class="action fa fa-trash"></i> </td>' +
                '</tr>';
        $("#lineItemBody").append(lineItemHTML);
        $("#lineItemItemId-" + lineItemIndex).select2();
        lineItemIndex++;
    }
    function itemDetail(id) {
        var currentLineItemIndex = id.split("-")[1];
         var itemData = $("#lineItemItemId-" + currentLineItemIndex).find(':selected').data();
        let item_name_counter = 0;
        //do not allow to add duplicate item in line items.
        $(".item-name").each(function (i) {
            if ($(this).val() == $("#" + id).val()) {
                if (item_name_counter > 0) {
                    alert("Duplicate Item can not be added again! Plese add another item.");
                    $("#" + id).val('').trigger("change");
                    return;
                }
                item_name_counter++;
            }
        });
        // no stock
        if(itemData.quantity < 1){
            alert("Out of stock! Please do purchase.");
            $("#" + id).val('').trigger("change");
             return;
        }

        $("#lineItemHsnOrSac-" + currentLineItemIndex).text(itemData.hsn_code);
        $("#lineItemQuantity-" + currentLineItemIndex).val(1);
        $("#lineItemRate-" + currentLineItemIndex).val(itemData.pcost);
        $("#lineItemTaxId-" + currentLineItemIndex).val(isIntraGST ? itemData.igst_tax_id : itemData.gst_tax_id);
        $("#lineItemPV-" + currentLineItemIndex).val(itemData.pv);
        $("#lineItemStockLabel-" + currentLineItemIndex).text(itemData.quantity);
        updateLineItem(id);
    }
    function updateLineItem(id) {
        var currentLineItemIndex = id.split("-")[1];
        var rate = parseFloat($("#lineItemRate-" + currentLineItemIndex).val());
        rate = rate == null || isNaN(rate) ? 0.00 : rate;
        var quantity = parseFloat($("#lineItemQuantity-" + currentLineItemIndex).val());
        quantity = quantity == null || isNaN(quantity) ? 0.00 : quantity;
        var pv = parseFloat($("#lineItemPV-" + currentLineItemIndex).val());
        pv = pv == null || isNaN(pv) ? 0.00 : pv;
        //stock checking
        let availableQuantity = parseFloat($("#lineItemStockLabel-" + currentLineItemIndex).text());
        if(quantity > availableQuantity){
            alert("Qty can not be greater than available stock");
            $("#lineItemQuantity-" + currentLineItemIndex).val(availableQuantity);
        }
        var pvAmount = pv * quantity;
        var amountTemp = rate * quantity;
        var taxId = $("#lineItemTaxId-" + currentLineItemIndex).val();
        if (taxId) { //TAXABLE
            var taxData =  $('#lineItemTaxId-' + currentLineItemIndex + ' option[value="' + taxId + '"]').data();
            let taxRate = parseFloat(taxData.rate);
            if (tax_exclusive_or_inclusive == 'INCLUSIVE') { //TAX INCLUSIVE
                var taxAmount = (amountTemp * taxRate) / (100 + taxRate);
                var amount = (amountTemp * 100) / (100 + taxRate);
                if (taxData.tax_type == "IGST") {
                    lineItemTaxArray[currentLineItemIndex] = [{taxName: "IGST", taxRate: taxRate, taxAmount: taxAmount}];
                } else { //GST
                    lineItemTaxArray[currentLineItemIndex] = [{taxName: "CGST", taxRate: taxRate/2, taxAmount: taxAmount/2}, {taxName: "SGST", taxRate: taxRate/2, taxAmount: taxAmount/2}];
                }
            } else { //TAX EXCLUSIVE
                var amount = amountTemp;
                var taxAmount = (amount * taxRate) / 100;
                if (taxData.tax_type == "IGST") {
                    lineItemTaxArray[currentLineItemIndex] = [{taxName: "IGST", taxRate: taxRate, taxAmount: taxAmount}];
                } else { //GST
                    lineItemTaxArray[currentLineItemIndex] = [{taxName: "CGST", taxRate: taxRate/2, taxAmount: taxAmount/2}, {taxName: "SGST", taxRate: taxRate/2, taxAmount: taxAmount/2}];
                }
            }
        } else { // NON TAXABLE
            var amount = amountTemp;
            lineItemTaxArray[currentLineItemIndex] = null;
        }

        $("#lineItemAmount-" + currentLineItemIndex).text(amount.toFixed(2));
        lineItemAmountArray[currentLineItemIndex] = amount;
        lineItemPVAmountArray[currentLineItemIndex] = pvAmount;

        totalUpdate();

    }
    function totalUpdate() {
        var subTotal = 0;
        var total = 0;
        var totalPVAmount = 0;
        var totalTaxAmount = 0;
        var taxLineItemHtmlLabel = '';
        var taxLineItemHtmlAmount = '';
        var lineItemTaxArrayNoDuplicate = [];

        for (i = 0; i < lineItemAmountArray.length; i++) {
            subTotal += lineItemAmountArray[i];
        }
        for (i = 0; i < lineItemPVAmountArray.length; i++) {
            totalPVAmount += lineItemPVAmountArray[i];
        }
        lineItemTaxArray.forEach(function (lineItemTaxA) {
            if (lineItemTaxA) {
                lineItemTaxA.forEach(function (lineItemTax) {
                    totalTaxAmount += lineItemTax.taxAmount;
//                    console.log("PP taxName:" + lineItemTax.taxName + " | taxRate:" + lineItemTax.taxRate + " | taxAmount:" + lineItemTax.taxAmount);
                    let isDuplicateTax = false;
                    if (lineItemTaxArrayNoDuplicate.length > 0) {
                        lineItemTaxArrayNoDuplicate.forEach(function (lineItemTaxTemp, key) {
//                            console.log(lineItemTaxTemp.taxName + '==' + lineItemTax.taxName + '&&' + lineItemTaxTemp.taxRate + '==' + lineItemTax.taxRate);
                            if (lineItemTaxTemp.taxName == lineItemTax.taxName && lineItemTaxTemp.taxRate == lineItemTax.taxRate) {
//                                console.log('if true body key:' + key + " | taxName:" + lineItemTaxTemp.taxName + " | taxRate:" + lineItemTaxTemp.taxRate + " | taxAmount:" + (lineItemTaxTemp.taxAmount + lineItemTax.taxAmount));
                                lineItemTaxArrayNoDuplicate[key] = {taxName: lineItemTaxTemp.taxName, taxRate: lineItemTaxTemp.taxRate, taxAmount: (lineItemTaxTemp.taxAmount + lineItemTax.taxAmount)};
                                isDuplicateTax = true;
                            }
                        });
                        if (!isDuplicateTax) {
//                            console.log('isDuplicateTax is false');
                            lineItemTaxArrayNoDuplicate[lineItemTaxArrayNoDuplicate.length] = lineItemTax;
                        }
                    } else {
//                        console.log('First tax added');
                        lineItemTaxArrayNoDuplicate[lineItemTaxArrayNoDuplicate.length] = lineItemTax;
                    }
                });
            }
        });
        lineItemTaxArrayNoDuplicate.forEach(function (lineItemTaxTemp) {
            if (lineItemTaxTemp) {
                taxLineItemHtmlLabel += lineItemTaxTemp.taxName + " (" + lineItemTaxTemp.taxRate + "%)<br/>";
                taxLineItemHtmlAmount += lineItemTaxTemp.taxAmount.toFixed(2) + "<br/>";

            }
        });

        total = subTotal + totalTaxAmount;
        $("#allItemTotalPVLabel").text(totalPVAmount.toFixed(2));
        $("#allItemSubTotalLabel").text(subTotal.toFixed(2));
        $("#allItemTotalLabel").text(total.toFixed(2));
        $("#taxLineItemHtmlLabel").html(taxLineItemHtmlLabel);
        $("#taxLineItemHtmlAmount").html(taxLineItemHtmlAmount);
    }
    function deleteLineItem(id) {
        if ($('.item-name').length > 1) {
            var currentLineItemIndex = id.split("-")[1];
            lineItemAmountArray[currentLineItemIndex] = 0;
            lineItemTaxArray[currentLineItemIndex] = null;
            lineItemPVAmountArray[currentLineItemIndex] = 0;
            $("#lineItemRow-" + currentLineItemIndex).remove();
            totalUpdate();
        }
    }

    function is_user_exist(fid) {
        $.get("ad_check_user.php", {fid: fid}, function (data, status) {
            if (data.is_exist) {
                $('#user_id').html(data.html);
                $('#fStateCode').html(data.fstateCode);
                $('#fStateName').html(data.fstateName);

                $('#shipping_state_name').val(data.fstateName);
                $('#shipping_state_code').val(data.fstateCode);

                if (adminStateCode && data.fstateCode && adminStateCode != data.fstateCode) {
                    //igst
                    isIntraGST = true;
                    $('#taxType').html("IGST [INTRA STATE] ");
                    $("#lineItemTaxId-0").html($("#intraGstTaxList").html());
                } else {
                    // gst
                    isIntraGST = false;
                    $('#taxType').html("GST [INTER STATE]");
                    $("#lineItemTaxId-0").html($("#interGstTaxList").html());
                }
            } else {
                $('#user_id').html("<p style='color:red;' >Invalid user ID </p>");
            }
        }, "json");
    }
</script> 


<?php
//print_r($_SESSION['pid']);echo "<br/>";
//print_r($_SESSION['qty']);
include('footer.php');
?>