<?php
$title = "Create franchise";
include 'header.php';
?>
<div class="container-fluid">
 <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <h4 class="page-title">Create Franchise</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Inventory</a></li>
                    <li class="breadcrumb-item active">Create Franchise</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end row -->
    <div class="row">
        <div class="col-12">
            <div class="card m-b-20">
                <div class="card-body">
                    <?php echo getMessage(); ?>
                    <form action="franchise_create_model.php" method="post" >
                        <div class="form-group row">
                            <!--                                            <label for="example-text-input" class="col-sm-2 col-form-label">Text</label>-->
                            <label class="col-sm-2 col-form-label" for="name">Franchise Login Id  <span>*</span></label>
                            <div class="col-sm-10">

                                <input name="login_id" id="login_id" type="text" pattern="\w{6,20}" required="required" onBlur="check_login_id(this.value)" maxlength="20" placeholder="Enter minimum 6 character" class="form-control"/>
                    <span id="login_error" class="help-block" ></span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="uid">Member User Id  </label>
                            <div class="col-sm-10">
                                <input name="uid" id="uid" type="text"  onBlur="check_sponser(this.value)"  placeholder="Enter user Id" class="form-control"/>
                                <span id="sponser" class="help-block" ></span>
                            </div>
                        </div>
                        
                        <div class="form-group row">
                            <!--                                            <label for="example-text-input" class="col-sm-2 col-form-label">Text</label>-->
                            <label class="col-sm-2 col-form-label" for="name">Name  <span>*</span></label>
<!--                                            <label class="col-sm-2 col-form-label" for="dob"> Name<span>*</span></label>-->
                            <div class="col-sm-10">

                                <input class="form-control" type="text" name="name" id="name" size="40" required="required">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="email">Email <span>*</span></label>
                            <div class="col-sm-10">
                                <input class="form-control"  type="text" name="email" id="email" size="40" required="required" >
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="password">Password<span>*</span> </label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="password" name="password" id="password" size="40" required="required">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="mobile">Mobile <span>*</span></label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="mobile" id="mobile" size="40" required="required">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="store_name">Store name <span>*</span></label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="store_name" id="store_name" size="40" required="required">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="address">Address </label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="address" id="address" size="40">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="city">City </label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="city" id="city" size="40" required="required">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="state">State </label>
                            <div class="col-sm-10">
                                <select class="form-control" name="state" id="state" required="required">
                                    <option value="">Select State</option>
                                    <?php
                                    $result_state = mysqli_query($connection, "SELECT `id`, `name`, `state_code`, `state_number`, `country_id` FROM `state`");
                                    while ($row_state = mysqli_fetch_object($result_state)) { ?>
                                        <option value="<?php echo $row_state->state_code; ?>" >
                                            <?php echo $row_state->name . " ($row_state->state_code) "; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="pin">PIN (ZIP)</label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="pin" id="pin" size="40">
                            </div>
                        </div>
                         
                        
                        <h3>Bank Details </h3>
                       
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="account_no">Account</label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="account_no" id="account_no" size="40">
                            </div>
                        </div> 
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="account_holder">Account holder name </label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="account_holder" id="account_holder" size="40">
                            </div>
                        </div>
                         <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="bank_name">Bank name </label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="bank_name" id="bank_name" size="40">
                            </div>
                        </div>
                         <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="bank_branch">Branch name </label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="bank_branch" id="bank_branch" size="40">
                            </div>
                        </div>
                         <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="pan">Pan No</label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="pan" id="pan" size="40">
                            </div>
                        </div>
                         <div class="form-group row">
                            <label class="col-sm-2 col-form-label" for="ifsc">IFSC</label>
                            <div class="col-sm-10">

                                <input class="form-control"  type="text" name="ifsc" id="ifsc" size="40">
                            </div>
                        </div>
                        <div class="form-group">
                            <div>
                                <button type="submit" name="submit" id="submit" value="Submit" class="btn btn-primary waves-effect waves-light">
                                    Submit
                                </button>
                            </div>
                        </div>
                     
                    </form>
                </div>

            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->


</div> <!-- container-fluid -->
<script>
    function check_login_id(login_id) {
        $("#validation_message_container").hide();
        var returnValue = false;
        $.ajax({
            url: "../get_franchise.php",
            data: {'login_id': login_id},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    $("#submit").attr("disabled", true);
                    $("#login_error").html('<b style="color:red">User id already exist</b>');
                    returnValue = false;
                } else if (login_id.length < 6 || login_id.length > 20) {
                    $("#submit").attr("disabled", true);
                    $("#login_error").html('<b style="color:red">User id min 6 or max 20 characters</b>');
                    returnValue = false;
                } else {
                    $("#login_error").html('<b style="color:green">Valid user id</b>');
                    $("#submit").removeAttr("disabled");
                    returnValue = true;
                }
            }
        });
        return returnValue;
    }
    function check_sponser(refer_id) {
        if(!refer_id){
                    $("#sponser").html('');
                    $("#submit").removeAttr("disabled");
                    return true;
                }
        // $("#validation_message_container").hide();
        var returnValue = false;
        $.ajax({
            url: "../get_sponser.php",
            data: {'refer_id': refer_id},
            type: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                if (data.invalid) {
                    returnValue = false;
                    $("#submit").attr("disabled", true);
                    $("#sponser").html('<b style="color:red">Invalid sponser id</b>');
                }else{
                    returnValue = true;
                    $("#sponser").html('<b style="color:green">' + data.name + ' - Valid sponser id</b>');
                    $("#submit").removeAttr("disabled");
                }
            }
        });
        return returnValue;
    }
</script>

<?php
include('footer.php');
?>